{$X+}
program Stars;
(*** Stars: 3d Starfield Example    ***)
(*** By whitefire @ Legacy Software ***)
(*** Legacy Software Copyright 1996 ***)

uses crt, graph;

const
     coefficient=8;
     maxzpos=round(4096 / coefficient);
     maxstars=4000;

var
   x,y,starx,stary,starz: array[0..4000] of integer;
   r: array[0..380] of integer;
   c,t,a, numstars, xpos, ypos, zpos: integer;
   newco: real;
   flag, keyflag: boolean;
   key: char;

function findx(xpos, zpos: integer): integer;
         begin
              findx:=((256 * xpos) div zpos)+160;
         end;

function findy(ypos, zpos: integer): integer;
         begin
              findy:=((256 * ypos) div zpos)+100;
         end;

procedure pixel(x,y,c:integer);
          begin
               mem[$A000:(x+(y*320))]:=c;
          end;

procedure display;
          label 1,2;
          begin
               for t:=0 to maxstars do
               begin
                    if (starz[t]=0) then goto 2;
                    1:
                      pixel (x[t],y[t],0);
                      starz[t]:=starz[t]-1;
                      x[t]:=findx (starx[t],starz[t]);
                      y[t]:=findy (stary[t],starz[t]);
                      if (x[t]<0) or (x[t]>320) or (y[t]<0) or (y[t]>200) then
                      begin
                           starx[t]:=0;
                           stary[t]:=0;
                           starz[t]:=0;
                           numstars:=numstars-1;
                           goto 2;
                      end;
                      pixel (x[t],y[t],31-round((starz[t]*coefficient)) div 256);
                    2:
               end;
          end;

procedure makestar;
          label 1;
          begin
               if numstars > maxstars then exit;
               for a:=0 to maxstars do
                   begin
                        if (starz[a]=0) and (starx[a]=0) and (stary[a]=0) then
                           begin
                                starx[a]:=r[random(380)];
                                stary[a]:=r[random(380)];
                                starz[a]:=round(4096/newco);
                                numstars:=numstars+1;
                                goto 1;
                           end;
                   end;
                   1:
          end;

begin
     asm
        mov ax,0013h
        int 10h
     end;
     randomize;
     for t:=-200 to -10 do
         begin
              r[c]:=t;
              c:=c+1;
         end;
     for t:=10 to 200 do
         begin
              r[c]:=t;
              c:=c+1;
         end;
     newco:=coefficient;
     repeat
           if newco=0 then newco:=8;
           makestar;
           display;
                   begin
                        if ord(key)=0 then
                           begin
                                if keypressed then key:=readkey;
                                if ord(key)=72 then
                                   begin
                                        newco:= newco+1;
                                   end;
                                if ord(key)=80 then
                                   begin
                                        newco:=newco-1;
                                   end;
                           end;
                        if ord(key)=13 then
                           begin
                                newco:=coefficient;
                           end;
                   end;
            delay(2);
            if keypressed then key:=readkey;
     until ord(key)=27;
     asm
        mov ax, 0003h
        int 10h
     end;
end.