#include "ray.h"
#include "globals.h"

USHORT anim_tex_count;
wall_entry ** anim_tex_list;

/*
   Is_Anim_Texture
   Returns TRUE if texture can be animated
*/

BOOL Is_Anim_Texture(wall_entry * test_wall)
{
return ( ((test_wall->anim_speed!=0)&&(test_wall->num_image>1))
            ? TRUE : FALSE);
}

/*
   Setup_Anim_Tex
   Builds a list of animated textures to speed updates in animation
   Notes: Requires that both floor and wall textures have been loaded.
   Otherwise will crash
*/

void Setup_Anim_Tex()
{
anim_tex_count=0;
USHORT cur_tex;

// First get a count of all anim textures
for (cur_tex=1; cur_tex<Number_Of_Textures; cur_tex++)
  if (Is_Anim_Texture(wall+cur_tex))
     anim_tex_count++;

for (cur_tex=0; cur_tex<(Number_Of_FTs-1); cur_tex++)
  if (Is_Anim_Texture(floortex+cur_tex))
     anim_tex_count++;

// Are there any animations?

if (anim_tex_count==0)
   return;

// allocate memory for list

anim_tex_list=(wall_entry **)NewPtr(anim_tex_count * sizeof(wall_entry *));

// set all members of list to see the anim texs

USHORT cur_anim_index=0;

for (cur_tex=1; cur_tex<Number_Of_Textures; cur_tex++)
   if (Is_Anim_Texture(wall+cur_tex)) {
      anim_tex_list[cur_anim_index]=wall+cur_tex;
      cur_anim_index++;
      }

for (cur_tex=0; cur_tex< (Number_Of_FTs-1); cur_tex++)
    if (Is_Anim_Texture(floortex+cur_tex)) {
       anim_tex_list[cur_anim_index]=floortex+cur_tex;
       cur_anim_index++;
       }
}

/*
    Animate_Textures
    Updates all textures based on the update num passed to the function
    Note: Requires Setup_Anim_Tex to be called first!
*/

void Animate_Textures(long update_num)
{
USHORT cur_anim_index;
wall_entry * cur_texture;
for (cur_anim_index=0; cur_anim_index<anim_tex_count; cur_anim_index++) {
   cur_texture=anim_tex_list[cur_anim_index];
   if (!(update_num & cur_texture->anim_speed)) {
        cur_texture->cur_image++;
        if (cur_texture->cur_image>=cur_texture->num_image)
           cur_texture->cur_image=0;
        }
   }
}
