#include "idbsp.h"
#include "shutdown.h"
#include "cmem.h"

STORAGE * linestore_i;

void Generate_BSP() {
Make_Line_List();
BuildBSP();
ConvBSP();
Free_Mem(linestore_i->data);
Free_Mem(linestore_i);
}

void *SafeMalloc(unsigned size)
{
	void *ret = Alloc_Mem(size);
	if (!ret)
		Error("\nSafeMalloc: Failed to allocate %u bytes",size);

	return ret;
}

void *SafeCalloc(unsigned num, unsigned size)
{
	void *ret = (void *)calloc(num,size);
	if (!ret)
		Error("\nSafeCalloc: Failed to allocate %u of %u bytes",num,size);

	return ret;
}

