#include "ray.h"
#include "globals.h"

typedef long bsp_stack_node;

#define BSP_STACK_LENGTH 64
#define NODE_MASK 0x8000


// There will be a stack used in the BSP drawing routine to simulate recursion,
// because as we all know, real recursion is too slow to use in games

short bsp_stack_size;
bsp_stack_node bsp_stack[BSP_STACK_LENGTH];

// Two routines to automate push and poping on BSP stack

inline BOOL PushBSPStack(bsp_stack_node push_value) {

   if (bsp_stack_size>=bsp_stack_length) {
      return TRUE;
   } else {
      bsp_stack[bsp_stack_size]=push_value;
      bsp_stack_size++;
      return FALSE;
   }

}

invoid BOOL PopBSPStack(bsp_stack_nod & pop_value) {

   if (bsp_stack_size<=0) {
      return TRUE;
   } else {
      bsp_stack_size--;
      pop_value=bsp_stack[bsp_stack_size];
   } /* endif */

}


// This routine examines the fifth bit of the child node to determine whether they
// are another recursive division, or a drawable subsector

inline BOOL GetChildType(USHORT child_num) {
   return (BOOL)(child_num & NODE_MASK);
}

void BSP_Recursion_Draw()
{

long current_bsp_section;

