#include "ray.h"
#include "globals.h"
#include "rayfile.h"
#include "resnames.h"
#include "rayspr.h"
#include "utils.h"
#include "sprfunc.h"
#include "fixed.h"

void Clear_Obj_Types();

BOOL obj_types_loaded=FALSE;

void F_Get_Object_Types()
{

   if (obj_types_loaded)
      Clear_Obj_Types();
   obj_types_loaded=TRUE;

   short dir_index=F_Find_And_Setup((PCHAR)OBJECT_TYPE_RES,
        (void * *)&Obj_Type_List, sizeof(object_type));
   if (dir_index==-1)
      return;

   Number_Of_OTs=directory[dir_index].length;
 
   Clear_Objects();

   short counter, cur_texture;
   object_type * cur_obj_type;
   short temp_short;
   long extra_data_offset, cur_pos;

   for (counter=0; counter<Number_Of_OTs; counter++) {

      cur_obj_type=Obj_Type_List+counter;

      F_Get_ULong(cur_obj_type->obj_class);

      F_Get_Short(cur_obj_type->stats.total_health);
      F_Get_Short(cur_obj_type->stats.base_speed);
      F_Get_Long(cur_obj_type->stats.sight_dis);
      cur_obj_type->stats.other_stats=NULL;

      F_Get_UShort(cur_obj_type->angle_num);
   
      cur_obj_type->frames=(ptexture *)NewPtr((cur_obj_type->angle_num) * sizeof(ptexture));
      cur_obj_type->rev_frames=(BOOL *)NewPtr((cur_obj_type->angle_num) * sizeof(BOOL));
      for (cur_texture=0; cur_texture < cur_obj_type->angle_num ; cur_texture++) {
         F_Get_Short(cur_obj_type->frames[cur_texture]);
         F_Get_Short(temp_short);
         if (temp_short==0)
            cur_obj_type->rev_frames[cur_texture]=FALSE;
         else cur_obj_type->rev_frames[cur_texture]=TRUE;
      } /* endfor */

      F_Get_UShort(cur_obj_type->width);
      F_Get_UShort(cur_obj_type->height);
      F_Get_UShort(cur_obj_type->eye_height);
      F_Get_UShort(cur_obj_type->stepping_height);
      F_Get_Short(temp_short);
      cur_obj_type->obj_width=convtoMYFIXED(temp_short);
      F_Get_Short(temp_short);
      cur_obj_type->block_width=convtoMYFIXED(temp_short);

      // setup various fields used for rendering

      cur_obj_type->half_angle=ANGLE_360/(cur_obj_type->angle_num*2);
      cur_obj_type->wshift=Check2Shift(cur_obj_type->width);
      cur_obj_type->hshift=Check2Shift(cur_obj_type->height);
      if (cur_obj_type->wshift > cur_obj_type->hshift) {
         cur_obj_type->wh_ratio=cur_obj_type->wshift - cur_obj_type->hshift;
      } else {
         cur_obj_type->wh_ratio=cur_obj_type->hshift - cur_obj_type->wshift;
      }

      F_Get_Short(temp_short);

      cur_obj_type->Update_Z=Get_Update_Z_Func(temp_short);

      F_Get_Short(temp_short);

      cur_obj_type->Load_Extra=Get_Load_Extra_Func(temp_short);

      F_Get_Short(temp_short);

      cur_obj_type->Update=Get_Update_Func(temp_short);

      F_Get_Short(temp_short);

      cur_obj_type->Message_Func=Get_Message_Func(temp_short);

      F_Get_Short(temp_short);

      cur_obj_type->Render_Func=Get_Render_Func(temp_short);
 
      F_Get_Short(temp_short);

      cur_obj_type->Render_Data_Loader=Get_Render_Data_Loader(temp_short);

      F_Get_Long(extra_data_offset);

      cur_pos=F_Abs_Pos();

      cur_obj_type->Render_Data_Loader(cur_obj_type, extra_data_offset);

      F_Seek_Abs(cur_pos);

   } /* endfor */

}

void F_Get_Objects()
{
   short dir_index=F_Find_Dir((PCHAR)OBJECT_RES);
   if (dir_index==-1)
      return;

   long object_count=directory[dir_index].length;
   F_Seek(directory[dir_index].start);

   short counter, type;
   long x, y, z;
   ULONG team;
   angle_type angle;
   pobject cur_object;
   long extra_data_offset, cur_pos;

   Clear_Objects();

   for (counter=0; counter<object_count; counter++) {

      F_Get_Long(x);
      F_Get_Long(y);
      F_Get_Long(z);
      F_Get_Long(angle);
      F_Get_Short(type);
      F_Get_ULong(team);

      cur_object=Create_Object(x<<SHIFT,y<<SHIFT,z,angle,type,NULL, team);

      // was an invalid object created
      if (cur_object==NULL)
         continue;

      F_Get_Long(extra_data_offset);

      cur_pos=F_Abs_Pos();

      cur_object->type->Load_Extra(cur_object, extra_data_offset);

      F_Seek_Abs(cur_pos);

   } /* endfor */

}

void Clear_Obj_Types() {
   DelPtr( Obj_Type_List);
   obj_types_loaded=FALSE;
}

