#include "ray.h"
#include "globals.h"
#include "rayfile.h"
#include "rgobject.h"
#include "voxel.h"
#include <mem.h>

void Reverse_Light_And_Color(PUCHAR source_image, long length);

void Load_Vox_Map(PUCHAR & vox_ptr , long offset)
{
   F_Seek(offset);
 
   RCastGobject vox_temp(2);
   char filename[F_NAME_LENGTH];

   // load bitmaps from pcx files
   F_Get_String_NT(filename, F_NAME_LENGTH);
   vox_temp.assigninfile(filename);
   vox_temp.load(0);
   F_Get_String_NT(filename, F_NAME_LENGTH);
   vox_temp.assigninfile(filename);
   vox_temp.load(1);

   //Palette no longer reversed as one palette is used
   //Reverse_Light_And_Color(vox_temp.Image(1), COL_ARR_SIZE);

   // now, this is tricky (i.e. bad code)
   // but is justified due to extreme speed demands
   // the altitudes array and color array are stacked
   // against eachother in memory, which will save time in
   // the essential assembly loop to draw the terrain

   vox_ptr=NewPtr(TOTAL_VOX_MEM);

   memcpy(vox_ptr, vox_temp.Image(0), ALT_ARR_SIZE);
   memcpy(vox_ptr+ALT_TO_COL_DIFF, vox_temp.Image(1), COL_ARR_SIZE);

}

void Reverse_Light_And_Color(PUCHAR source_image, long length)
{
   PUCHAR dest_image=NewPtr(length);
   UCHAR cur_light, cur_color;
   for (long cur_pixel=0; cur_pixel<length; cur_pixel++) {
      cur_light=(source_image[cur_pixel] & 0xf0) >> 4;
      cur_color=(source_image[cur_pixel] & 0x0f);
      dest_image[cur_pixel]=cur_light+(cur_color<<4);
      } /* endfor */

   memcpy(source_image, dest_image, length);
   DelPtr(dest_image);
}
