#include "gentree.h"
#include "voxel.h"
#include "sprinter.h"
#include "fixed.h"
#include "maxmins.h"
#include <time.h>
#include <stdlib.h>

#define randomize()     srand((unsigned)time(NULL))

#define TREE_TYPE 0
#define TREE_COUNT_SCALER 26000
#define MAX_RAND 32767
#define MIN_DIS_FROM_SEG 10

BOOL Within_Segs(pobject new_object);

inline long random(long range)
{
return (fixedmd((LONG)rand(), range, MAX_RAND));
}

inline BOOL On_Seg_Right(pseg test_seg, long base_x, long base_y) {
   long x1,x2,y1,y2;
   x1=Vector_List[test_seg->v[0]].x;
   y1=Vector_List[test_seg->v[0]].y;
   x2=Vector_List[test_seg->v[1]].x;
   y2=Vector_List[test_seg->v[1]].y;

   // this is different from other similar test because I want the trees to fit well into the sub sec
   if ( ( ((x1-x2)*((base_y>>SHIFT)-y2)) - ((y1-y2)*((base_x>>SHIFT)-x2)) ) >= MIN_DIS_FROM_SEG) {
      return TRUE;
   } else {
      return FALSE;
   }
}

void Gen_Tree() {
long cur_x, cur_y;
long min_x, min_y, max_x, max_y;
long range_x, range_y, map_area;
long tree_count;
pobject new_tree;

Get_Map_Max_Mins(min_x, min_y, max_x, max_y);
range_x=max_x-min_x;
range_y=max_y-min_y;

map_area=range_x*range_y;
tree_count=map_area/TREE_COUNT_SCALER;
randomize();
for (short cur_tree=0; cur_tree<tree_count; cur_tree++) {
   cur_x=(random(range_x)+min_x)<<SHIFT;
   cur_y=(random(range_y)+min_y)<<SHIFT;
   new_tree=Create_Object(cur_x, cur_y, 0,0,TREE_TYPE, NULL, 0);
   if (!new_tree->cur_ss->flags&VOXEL_SSECTOR) {
      Kill_Object(new_tree);
   } else {
      if (!Within_Segs(new_tree)) {
         Kill_Object(new_tree);
      }
   }
} /* endfor */

}

BOOL Within_Segs(pobject new_object) {
   short seg_start=new_object->cur_ss->seg_start;
   short seg_end=new_object->cur_ss->seg_end;

   BOOL still_in=TRUE;
   for (short cur_seg=seg_start; cur_seg<=seg_end; cur_seg++) {
      if (!On_Seg_Right(Seg_List+cur_seg, new_object->x, new_object->y)) {
         still_in=FALSE;
      }
   }
   return still_in;
}
