#include "os.h"
#include "keyinfo.h"
#include "keyboard.h"
#include "playint.h"
#include "ray.h"
#include "sprtypes.h"
#include "rayspr.h"

int raw_key=0;                  // the global raw keyboard data aquired from the ISR
 
int key_table[MAX_TRACKED_INPUTS-1] = {0,0,0,0,0,0}; // the key state table for the motion keys

#ifdef OS_DOS
#include <dos.h>
#include <conio.h>
#include <i86.h>

#define INT_CONTROL     0x20         // interrupt control register 
#define KEYBOARD_INT    0x09         // the keyboard interrupt vector 
#define KEY_BUFFER      0x60         // keyboard buffer area 
#define KEY_CONTROL     0x61         // keyboard control register 

unsigned short getkey(void);

// Routine to read a key directly from the port
#pragma aux getkey = \
   " sti" \
   "in al, 60h" \
   "xor ah,ah" \
   "mov bx, ax" \
   "in al, 61h" \
   "or al, 82h" \
   "out 61h,al" \
   "and al,7fh" \
   "out 61h,al" \
   "mov al,20h" \
   "out 20h,al" \
   modify [ax bx] \
   value [bx];

void (_interrupt _far *Old_Key_Isr)(); // holds old keyboard interrupt handler 

void _interrupt _far New_Key_Int(void) 
{ 
// this function links into the keyboard interrupt and takes over.  it is called 
// when a key is pressed.  Note: how it differs from the one were saw in the 
// chapter on I/O.  It has been modified to take into consideration the demo 
// mode of the system 
 
int temp_key=getkey();
// now for some C to update the arrow state table 
 
// process the key and update the table 
Process_Key(temp_key);

} // end New_Key_Int 

#endif

void Init_Keyboard() {
#ifdef OS_DOS
Old_Key_Isr = _dos_getvect(KEYBOARD_INT); 
 
_dos_setvect(KEYBOARD_INT, New_Key_Int); 
#endif
}

void Close_Keyboard() {
#ifdef OS_DOS
_dos_setvect(KEYBOARD_INT, Old_Key_Isr); 
#endif
}

void Process_Key(short temp_key) {
 
switch(temp_key)
      { 
      case MAKE_UP:    // pressing up 
           { 
           key_table[INDEX_UP]    = Obj_Type_List[PLAYER_TYPE].stats.base_speed;
           } break; 
 
      case MAKE_DOWN:  // pressing down 
           { 
           key_table[INDEX_DOWN]  = Obj_Type_List[PLAYER_TYPE].stats.base_speed;
           } break; 
 
      case MAKE_RIGHT: // pressing right 
           { 
           key_table[INDEX_RIGHT] = PLAYER_ROT_SPEED;
           } break; 
 
      case MAKE_LEFT:  // pressing left 
           { 
           key_table[INDEX_LEFT]  = PLAYER_ROT_SPEED;
           } break; 

      case MAKE_LUP: // look up
           {
           key_table[LOOK_UP]=ANGLE_2;
           } break;

      case MAKE_LDOWN: // look down
           {
           key_table[LOOK_DOWN]=ANGLE_2;
           } break;

      case MAKE_CNTL: // ctrl key
           {
           key_table[INDEX_GUN]=1;
           }
           break;

      case BREAK_UP:    // releasing up 
           { 
           key_table[INDEX_UP]    = 0; 
           } break; 
 
      case BREAK_DOWN:  // releasing down 
           { 
           key_table[INDEX_DOWN]  = 0; 
           } break; 
 
      case BREAK_RIGHT: // releasing right 
           { 
           key_table[INDEX_RIGHT] = 0; 
           } break; 
 
      case BREAK_LEFT:  // releasing left 
           { 
           key_table[INDEX_LEFT]  = 0; 
           } break; 
 
      case BREAK_LUP: // releasing look up
           {
           key_table[LOOK_UP]=0;
           } break;

      case BREAK_LDOWN: // releasing look down
           {
           key_table[LOOK_DOWN]=0;
           } break;

      case BREAK_CNTL: // releasin control key
           {
           key_table[INDEX_GUN]=0;
           }
           break;

      default: raw_key=temp_key; break;
 
 
      } // end switch 
}
