#include "ray.h"
#include "globals.h"
#include "rayrt.h"
#include <mem.h>

#define CL_BASE_NODE 0

extern "C" clip_info_list * column_data;

extern "C" clip_info_node * clip_info_array;

extern "C" clip_info_list next_free_node_cl;

inline clip_info_node * Cl_GetNodeData(clip_info_list index)
{   
   return (clip_info_array + index);
}

inline clip_info_list Cl_GetNextNode(clip_info_list index)
{
   return (clip_info_array[index].next_node);
}

inline clip_info_list Cl_AllocateNode() {
   next_free_node_cl++;
   return next_free_node_cl;
}

inline void Cl_AttachNode(clip_info_list base_node, clip_info_list next_node)
{
   clip_info_array[base_node].next_node=next_node;
}

inline void Cl_InitList()
{
   next_free_node_cl=CL_BASE_NODE;
   clip_info_array[CL_BASE_NODE].y_val=0;
   clip_info_array[CL_BASE_NODE].WIN_TOP=0;
   clip_info_array[CL_BASE_NODE].WIN_BOTTOM=WINDOW_HEIGHT;
   memset(column_data, CL_BASE_NODE, WINDOW_WIDTH*sizeof(clip_info_list));
}

