#include "ray.h"
#include "rayrend.h"
#include "raycl.h"
#include "rayvb.h"
#include "globals.h"
#include "voxinter.h"
#include "asm.h"
#include "scrconf.h"

#define MIN_RENDER_MODE 0
#define MAX_RENDER_MODE 1

#define APPROX_INFO_SIZE 10

void Render_Init() {

bounds=(vb_node *)NewPtr(Get_Phys_Screen_Width() * sizeof(vb_node));

wall_runs=(wall_run_info *)NewPtr(MAX_WALL_RUNS * sizeof(wall_run_info));
floor_runs=(floor_run_info *)NewPtr(MAX_FLOOR_RUNS * sizeof(floor_run_info));

Draw_Sub_Sector_Setup();

Init_Slope_Table();

}

void Render_Close() {

   DelPtr(bounds);
   DelPtr(wall_runs);
   DelPtr(floor_runs);
   Draw_Sub_Sector_Close();
   Clear_Slope_Table();

}

render_type render_mode;

void Render_Screen(long x, long y, long z, long view_angle) {
   switch (render_mode) {
   case MODE_3D:
      Ray_Caster(x, y, z, view_angle);
      break;
   case MODE_2D:
      Render_2d(x, y, view_angle);
      break;
   default: 

     break;
   } /* endswitch */
}

void SwitchRenderMode() {
   render_mode++;
   if (render_mode > MAX_RENDER_MODE) {
      render_mode=MIN_RENDER_MODE;
   } /* endif */
   clearBuff();
}

void SetRenderMode(render_type mode) {
   render_mode=mode;
   clearBuff();
};

render_type GetRenderMode() { return render_mode; };
