#ifndef _RAYRT_
#define _RAYRT_
#include "ray.h"

typedef USHORT clip_info_list;
typedef SHORT vb_node_index;
typedef struct VB_NODE * pvb_node;

typedef struct WALL_RUN_INFO {
   short ray;
   short top;
   short scale;
   short column;
   long clip;
   long increment;
   Ptr texture;
   Byte * light;
   short bound_val;
   Byte width_shift;
   } wall_run_info;

typedef struct FLOOR_RUN_INFO {
   Ptr texture;
   Byte * light;
   SHORT screen_x;
   SHORT screen_y;
   SHORT scale;
   MYFIXED x_inc;
   MYFIXED y_inc;
   MYFIXED map_x;
   MYFIXED map_y;
   } floor_run_info;

typedef struct CLIP_INFO_NODE {
   LONG y_val;
   SHORT WIN_TOP, WIN_BOTTOM;
   clip_info_list next_node;
} clip_info_node;

typedef struct VB_NODE {
   SHORT left, right;
   vb_node_index next_node, back_node;
} vb_node;

#endif
