#include "fixed.h"
#include "ray.h"
#include "globals.h"
#include <stddef.h>
#include <math.h>
#include "verttan.h"

void    Build_Light_Tables();
void    Build_Movement_Table();
void    Build_Middle_Table();
long    floatRound(float f);      

inline MYFIXED Get_Angle_Difference_MYFIXED(MYFIXED angle1, MYFIXED angle2)
{
   MYFIXED temp_angle=angle1-angle2;
   if (temp_angle < 0) {
      temp_angle+=(ANGLE_360 << SHIFT);
   } /* endif */
   return temp_angle;
}

/********************* Build Tables *********************/

void Build_Tables(void)
{

distance_table=NULL;

// this function builds all the look up tables for the system

int ang;
float rad_angle;

// allocate memory for all look up tables

// tangent tables equivalent to slopes

tan_table     = (long  *)NewPtr(sizeof(long) * (ANGLE_360+1) );
inv_tan_table = (long  *)NewPtr(sizeof(long) * (ANGLE_360+1) );

rcos_table     = (long  *)NewPtr(sizeof(long) * (ANGLE_360+1) );
rsin_table = (long  *)NewPtr(sizeof(long) * (ANGLE_360+1) );

// 1/cos and 1/sin tables used to compute distance of intersection very
// quickly

inv_cos_table = (long  *)NewPtr(sizeof(long) * (ANGLE_60+1) );

height_table=(MYFIXED *)NewPtr(sizeof(MYFIXED) * (MAXDIS));

//y_movement_table=(MYFIXED *)NewPtr(sizeof(MYFIXED) * (MAXDIS));

tex_mark_table=(tex_mark *)NewPtr((WINDOW_HEIGHT) * sizeof(tex_mark));

middle_table=(MYFIXED *)NewPtr(sizeof(MYFIXED) * (MAXDIS));

for (ang=ANGLE_0; ang<=ANGLE_360; ang++)
    {
    rad_angle = (float)((3.272e-4) + ang * 2*3.141592654/ANGLE_360);
    
    tan_table[ang]     = floatRound(tan(rad_angle)*ONE);
    inv_tan_table[ang] = floatRound((ONE)/(tan(rad_angle)));
        
        rcos_table[ang]=floatRound(cos(rad_angle)*ONE);
        rsin_table[ang]=floatRound(sin(rad_angle)*ONE);

    // create the sin and cosine tables to copute distances

    } // end for ang


// Build tables used calculate wall height

Build_Height_Table();

// Build tables to hold floor movement values

Build_Movement_Table();

// Build table used for looking up+down

Build_Middle_Table();

// Build table of vertical movement of rays per unit distance

Build_Vertical_Distance_Table();

// prepare the lighting table

Build_Light_Tables();

} // end Build_Tables

/////////////////////////////////////////////////////////////////////////////

#define VT_SHIFT 16

void Build_Vertical_Distance_Table()
{
   MYFIXED slope_start, slope_end, slope_sum, slope_increment, temp_slope;
   angle_type start_angle, end_angle;

   if (distance_table!=NULL)   // allocate the tables
        DelPtr( distance_table);
   distance_table=(long *)NewPtr(sizeof(long) * WINDOW_HEIGHT);

   start_angle=Get_Angle_Sum(0, VERTICAL_VIEW_RANGE/2);
   end_angle=Get_Angle_Difference(0, VERTICAL_VIEW_RANGE/2);

   slope_start=tan_table[start_angle]<<(VT_SHIFT);
   slope_end=tan_table[end_angle]<<(VT_SHIFT);

   slope_sum=slope_start;
   slope_increment=(slope_end-slope_start)/WINDOW_HEIGHT;

   for (long index=0; index < WINDOW_HEIGHT; index++) {

      temp_slope=slope_sum+(tan_table[VERTICAL_VIEW_ANGLE]<<VT_SHIFT);
      if (temp_slope==0) temp_slope=1;
      if (temp_slope<0) temp_slope=-temp_slope;

      distance_table[index]=fixeddiv(ONE << VT_SHIFT, temp_slope);

      slope_sum+=slope_increment;
   }

}

void Build_Movement_Table()
{
/*

   long tempMovement;

   if (movement_table!=NULL) 
      DelPtr( movement_table);

   movement_table=(MYFIXED *)NewPtr(sizeof(MYFIXED) * MAXDIS);

   for (long index=0; index < MAXDIS; index++) {
      // get the distance incrementer in the texture
      tempMovement=((index*tan_table[HORIZ_VIEW_RANGE>>1])
        /WINDOW_MIDDLEW);

      movement_table[index]=tempMovement;
   }

*/

x_inv_trans=(tan_table[HORIZ_VIEW_RANGE>>1]<<X_TRANS_SHIFT)/(WINDOW_MIDDLEW);
}

void Build_Height_Table()
{
   long distance;
   height_table[0]=0x7fff;

   y_trans=fixeddiv(WINDOW_MIDDLE << SHIFT, tan_table[VERTICAL_VIEW_RANGE >> 1]);
   y_inv_trans=tan_table[VERTICAL_VIEW_RANGE >> 1] << (SLIVER_SHIFT-SHIFT);
   y_inv_trans=y_inv_trans / WINDOW_MIDDLE;
   y_inv_trans<<=W_TEX_SHIFT;

}

long    floatRound(float f)
        {
        long other;
        float   some;
        
        other=(long)f;  
        some=fabs((float)(f-other));
        
        if( some>=0.5)
                {
                some=1.0-some;
                some+=0.1;
                other=some+f;
                } 
        return other;
        }
        
void Build_Light_Tables()
{
pal_table=(Byte * *)NewPtr(16 * sizeof(Byte *));
float sum_array[16];
float increment_array[16];
short index1, index2, index3, temp1;
float temp2;
for (index1=0; index1<16; index1++) {
  sum_array[index1]=increment_array[index1]=((float)index1/16);
  }
for (index1=0; index1<16; index1++) {
  pal_table[index1]=(Byte *)NewPtr(256);
  for (index2=0; index2<16; index2++) {
    for (index3=0; index3<16; index3++) {
      if (index3==1) {
         temp1=0;
         temp2=index1;
      } else { temp1=index3; temp2=0; }
      pal_table[index1][index3*16+index2]=(temp1*16)+((Byte)(sum_array[index2]+temp2));
    }
  sum_array[index2]+=(increment_array[index2]);
  }                                                                           
}
}

void Build_Middle_Table()
{
   vert_angle_tangent=tan_table[VERTICAL_VIEW_ANGLE];
}
