#include "ray.h"
#include "globals.h"
#include "raywidth.h"
#include "fixed.h"
#include "scrconf.h"
#include "asm.h"
#include "voxinter.h"
#include "slopes.h"

#define MIN_WINDOW_WIDTH 20
#define MAX_HORIZ_FOV ANGLE_90
#define MIN_HORIZ_FOV ANGLE_15

extern void Build_Movement_Table();

void Setup_Horiz_Window_Change();

void Set_Window_Width(short width) {
// Sets width of window

   // is it legal?
   if ((width > Get_Phys_Screen_Width())||(width <= MIN_WINDOW_WIDTH))
      return;

   WINDOW_WIDTH=width;
   WINDOW_MIDDLEW=width/2;
   
   //setup the new window
   Setup_Horiz_Window_Change();
}

void Set_Horiz_FOV(angle_type horiz_angle) {
// routine to set horiz FOV

   // is it legal?
   if ((horiz_angle>MAX_HORIZ_FOV) || (horiz_angle<=MIN_HORIZ_FOV))
      return;
   HORIZ_VIEW_RANGE=horiz_angle;

   // setup the new window
   Setup_Horiz_Window_Change();
}

void Setup_Horiz_Window_Change() {
   clearBuff();
   SCALE_FACTOR=fixeddiv(WINDOW_MIDDLEW, tan_table[HORIZ_VIEW_RANGE>>1]);
   Build_Movement_Table();
   Recalc_Slope_Table();
   V_Recalc_Length();
}
