#include <stddef.h>
#include <dos.h>
#include "rcbitmap.h"

rcbitmap * bitmap_struct;
fstream inpcxfile;
fstream outpcxfile;

struct pcx_header {
  CHAR manufacturer;    // Always set to 0
  CHAR version;         // Always 5 for 256-color files
  CHAR encoding;        // Always set to 1
  CHAR bits_per_pixel;  // Should be 8 for 256-color files
  SHORT  xmin,ymin;       // Coordinates for top left corner
  SHORT  xmax,ymax;       // Width and height of image
  SHORT  hres;            // Horizontal resolution of image
  SHORT  vres;            // Vertical resolution of image
  CHAR palette16[48];   // EGA palette; not used for
			//  256-color files
  CHAR reserved;        // Reserved for future use
  CHAR color_planes;    // Color planes
  SHORT  bytes_per_line;  // Number of bytes in 1 line of
			//  pixels
  SHORT  palette_type;    // Should be 2 for color palette
  CHAR filler[58];      // Nothing but junk
};

LONG Bitmap_In_File(PCHAR filename,ULONG locate)
{
  if (inpcxfile.is_open())
    inpcxfile.close();
  inpcxfile.open(filename,ios::binary | ios::in);
  if  (inpcxfile.fail())
	return -1;
  else {inpcxfile.seekg(locate,ios::beg);
 	return 0;}
}

LONG Bitmap_Out_File(PCHAR filename,ULONG locate)
{
  if (outpcxfile.is_open())
    outpcxfile.close();
  outpcxfile.open(filename,ios::binary | ios::out | ios::truncate);
  if  (outpcxfile.fail())
	return -1;
  else {outpcxfile.seekp(locate,ios::beg);
 	return 0;}
}

LONG Setup_Pcx_Read()
{
if (!inpcxfile.is_open())
  return -1;
LONG seek=inpcxfile.tellg();
inpcxfile.seekg(0L,ios::beg);
pcx_header header;
inpcxfile.read((PCHAR)&header,128);
bitmap_struct->image_size=((LONG)header.bytes_per_line)*((LONG)header.color_planes)
*((LONG)(1+header.ymax-header.ymin));
bitmap_struct->width=1+header.xmax-header.xmin;
bitmap_struct->height=1+header.ymax-header.ymin;
inpcxfile.seekg(seek,ios::beg);
return 0;
}

LONG Setup_Pcx_Write()
{        
if (!outpcxfile.is_open())
  return -1;
pcx_header header;
header.manufacturer=10;
header.version=5;
header.encoding=1;
header.bits_per_pixel=8;
header.xmin=0;header.ymin=0;
header.xmax=bitmap_struct->width-1;header.ymax=bitmap_struct->height-1;
header.hres=300; header.vres=300;
header.palette16[0]=1;
header.palette16[1]=0;
header.palette16[2]=1;
header.palette16[3]=0;
header.palette16[4]=1;
header.reserved=0;
header.color_planes=1;
header.bytes_per_line=bitmap_struct->width;
header.palette_type=1;
outpcxfile.write((PCHAR)&header,sizeof(header));
return 0;
}

LONG Write_Pcx()
{
   if (!outpcxfile.is_open())
      return (-1);
   length=0;
   static UCHAR buffer[5*1024];
   PUCHAR image_ptr=bitmap_struct->image;
   char mode=1;
   static UCHAR writeout;
   static UCHAR bytecount;
   LONG bufptr=0;
   LONG buflen=5*1024;
   LONG i=0;
   while (i<bitmap_struct->image_size) {
       if (mode>0) {
	  if (bufptr>=buflen) {
	  length+=5*1024;
	     bufptr=0;
	     outpcxfile.write(buffer,5*1024);}
	  writeout=*(image_ptr++);
	  if (((bitmap_struct->image_size-i>1)&&(writeout==*(image_ptr)))||(writeout > 0xbf)) {
	     bytecount=1;
	     mode=0;
	  } else { buffer[bufptr++]=writeout; i++;}
       }
       else {
	   if ((bitmap_struct->image_size-i>1)&&
		(bytecount<0x39)&&(*(image_ptr)==writeout)){
	    bytecount++;
	    image_ptr++;}
	  else {
	    buffer[bufptr++]=bytecount+0xc0;
	    if (bufptr>=buflen) {
	       length+=5*1024;
	       bufptr=0;
	       outpcxfile.write(buffer,buflen);}
	    buffer[bufptr++]=writeout;
	    mode=1;
	  }
             i++;
       }
   }
outpcxfile.write(buffer,bufptr);
length+=bufptr;
return 0;
}
	 
LONG Load_Pcx()
{
  length=0;
  if (!inpcxfile.is_open())
    return (-1);
  if ((bitmap_struct->image=new UCHAR [bitmap_struct->image_size])==NULL){
    delete bitmap_struct->image;
    return 1;}
  LONG seek=inpcxfile.tellg();
  inpcxfile.seekg(128L,ios::cur);
  static UCHAR buffer[5*1024];
  PUCHAR image_ptr=bitmap_struct->image;
  CHAR mode=1;
  LONG bufptr=0;
  LONG buflen=0;
  static UCHAR readin;
  static UCHAR bytecount;
  for (LONG i=0;i<bitmap_struct->image_size;i++){
    if (mode > 0)
       {
	 if (bufptr>=buflen)
	    {bufptr=0;
	    inpcxfile.read(buffer,5*1024);
               buflen=inpcxfile.gcount();
               length+=buflen;
	    if (buflen==0)
	      break;} //if (bufptr>=buflen)
	 readin=buffer[bufptr++];
	 if (readin>0xbf)
	   {
	   bytecount= (LONG)((LONG)readin & 0x3f);
	   if (bufptr>=buflen)
	    {bufptr=0;
               inpcxfile.read(buffer,5*1024);
               buflen=inpcxfile.gcount();
               length+=buflen;
	    if (buflen==0)
	      break;} //if (bufptr>=buflen)
	   readin=buffer[bufptr++];
	   if (--bytecount > 0) mode=0;
	   } //if (readin>0xbf)
       }  //if (mode)
    else if (--bytecount == 0) mode=1;
    *image_ptr++=readin;
  } //for loop
  inpcxfile.clear();
  inpcxfile.seekg(seek,ios::beg);
  return 0;
}

LONG Load_Bitmap(char * filename, ULONG locate)
{
  Bitmap_In_File(filename, locate);
  Setup_Pcx_Read();
  if (Read_Pcx()) {
    inpcxfile.close();
    return -1;}
  inpcxfile.close();
  return 0;
}

LONG Write_Bitmap(char * filename, ULONG locate)
{
  Bitmap_Out_File(filename, locate);
  if (Write_Pcx()) {
    outpcxfile.close();
    return -1;}
  outpcxfile.close();
  return 0;
}

void Show_Bitmap(rcbitmap * screen, USHORT x, USHORT y)
{
PUCHAR imageptr=bitmap_struct->image;
PUCHAR scrnptr=(screen->image+screen->width*y+x);
for (LONG i=0;i<bitmap_struct->height;i++) {
  for (LONG j=0;j<bitmap_struct->width;j++)
    *(scrnptr++)=*(imageptr++);
  scrnptr+=(SCREEN_WIDTH-bitmap_struct->width);
}
}
