#include "ray.h"

#ifdef OS_DOS
#include "modplay.h"
#endif

#include "soundint.h"  
#include "cmem.h"
#include <process.h>
#include <stddef.h>
#include <stdio.h>

#define DEF_WAV "fhorse.wav"
#define DEFAULT_IO 0x220
#define DEFAULT_IRQ 5
#define DEFAULT_DMA 1
#define KHZ_22 22222
#define DEF_CHANS 8
#define DEF_VOICE 7
#define SC_FILE "sound.cfg"
#define START_CHANNEL 4
#define MAX_CHANNEL 8
#define MAX_SAMPLES 20

UCHAR cur_channel=START_CHANNEL;
USHORT the_port;
UCHAR the_IRQ, the_DMA;
BOOL sound_exists;
BOOL mod_playing, music_playing;
BOOL sounds_playing[MAX_CHANNEL-START_CHANNEL];
USHORT sample_count;

#ifdef OS_DOS
Module * the_song;
Sample * samples[MAX_SAMPLES];
#endif

void Init_Sound() {
#ifdef OS_DOS
FILE * fp;
short temp_1, temp_2, temp_3;

fp=fopen("sound.cfg", "r+t");
if (fp==NULL) {
   fclose(fp);
   system("sndcfg.exe");
   fopen("sound.cfg", "r+t");
   }
fscanf(fp, "%hd\n", &temp_1);
sound_exists=(temp_1>0 ? TRUE : FALSE);
if (sound_exists) {
   fscanf(fp, "%hd\n%hd\n%hd\n", &temp_1, &temp_2, &temp_3);
   the_port=temp_1;
   the_IRQ=temp_2;
   the_DMA=temp_3;
}
fclose(fp);
mod_playing=FALSE;
music_playing=FALSE;
the_song=NULL;
MODPlayModule(NULL, DEF_CHANS, KHZ_22, the_port, the_IRQ, the_DMA, PM_MANUAL);
sample_count=0;
#endif
}

void Play_Song(PCHAR filename) {
if (sound_exists) {
#ifdef OS_DOS
      if (music_playing) {
         MODStopModule();
      }
      if (mod_playing) {
         MODFreeModule(the_song);
      }
      the_song=MODLoadModule(filename);
      if (music_playing) {
         MODPlayModule(the_song, DEF_CHANS, KHZ_22, the_port, the_IRQ, the_DMA, PM_MANUAL);
      }
      mod_playing=TRUE;
#endif
}
}

void Start_Music() {
if (sound_exists) {
#ifdef OS_DOS
   MODStopModule();
   MODPlayModule(the_song, DEF_CHANS, KHZ_22, the_port, the_IRQ, the_DMA, PM_MANUAL);
   music_playing=TRUE;
#endif
}
}

void Stop_Music() {
if (sound_exists) {
#ifdef OS_DOS
   MODStopModule();
   MODPlayModule(NULL, DEF_CHANS, KHZ_22, the_port, the_IRQ, the_DMA, PM_MANUAL);
   music_playing=FALSE;
#endif
}
}

long Load_Sound(PCHAR filename) {
if (sound_exists) {
#ifdef OS_DOS
   if (sample_count<MAX_SAMPLES)
      samples[sample_count++]=MODLoadSample(filename);
   else return -1;
#endif
}
return (sample_count-1);
}

void Play_Sound(long id) {
if (id==-1)
  return;
if (sound_exists) {
#ifdef OS_DOS
   MODPlaySample(cur_channel, samples[id]);
   if ((++cur_channel)>=MAX_CHANNEL)
      cur_channel=START_CHANNEL;
#endif
}

}

void Update_Sound() {
#ifdef OS_DOS
if (sound_exists)
   MODPoll();
#endif
}

void Close_Sound() {
   if (sound_exists) {
#ifdef OS_DOS
      MODStopModule();
      if (mod_playing) {
         MODFreeModule(the_song);
      }
#endif
   }
}
