#include "ray.h"
#include "globals.h"
#include "bspmove.h"
#include "blockbsp.h"
#include "rayspr.h"
#include "blockmap.h"
#include "forever.h"
#include "abs.h"
#include "sign.h"
#include "fixed.h"
#include "error.h"
#include "collisio.h"
#include "message.h"
#include "objcol.h"

#define MIN_DIS_FROM_WALL 1500
#define MAX_LINE_DIS (128<<SHIFT)

void Do_Move_Correction(pvector2 input_source_vec, pvector2 delta_vec);
void Do_Block_Correction(short block_x,
   short block_y, pvector2 dest_vec, plinedef closest_line, MYFIXED & min_dis);


short Move_Object_Dir(pobject source_obj, angle_type move_angle, long distance)
{
vector2 delta_vec;
delta_vec.x=(rcos_table[move_angle]*distance)>>SHIFT;
delta_vec.y=(rsin_table[move_angle]*distance)>>SHIFT;
return Move_Object_Vec(source_obj, &delta_vec);
}

short Move_Object_Vec(pobject source_obj, pvector2 delta_vec)
{
vector2 source_vec;
source_vec.x=source_obj->x;
source_vec.y=source_obj->y;

wall_collision_info wal_col;
wal_col.move_obj=source_obj;
wal_col.delta_vec=delta_vec;
checkwalls(&wal_col);
if (wal_col.found_collision) {
  if (Send_Specific_Message(NULL, source_obj, WALL_COLLISION, (pdata)&wal_col))
    return 0;
}

obj_collision obj_col;
obj_col.move_obj=source_obj;
obj_col.delta_x=delta_vec->x;
obj_col.delta_y=delta_vec->y;
Check_Obj_Collision(&obj_col);
if (obj_col.found_collision) {
  if (Send_Specific_Message(obj_col.move_obj, obj_col.col_obj,
     HIT_BY_OBJ, (pdata)&obj_col))
     return 0;
  if (Send_Specific_Message(obj_col.col_obj, obj_col.move_obj,
     HIT_OBJ, (pdata)&obj_col))
     return 0;
} 

delta_vec->x=obj_col.delta_x;
delta_vec->y=obj_col.delta_y;

source_obj->x+=delta_vec->x;
source_obj->y+=delta_vec->y;

USHORT new_block_x, new_block_y;
new_block_x=Block_X(source_obj->x);
new_block_y=Block_Y(source_obj->y);
if ( (new_block_x!=source_obj->block_x) || (new_block_y!=source_obj->block_y) ) {
   OL_Delete_Node(source_obj->block_node,
      *Get_Block_Obj_List(source_obj->block_x, source_obj->block_y));
   OL_Push_Node(source_obj->block_node,
      *Get_Block_Obj_List(new_block_x, new_block_y));
   source_obj->block_x=new_block_x;
   source_obj->block_y=new_block_y;
   }

long starting_node_index;

// Get a starting index to do bsp seaching
starting_node_index=Get_Closest_Node(source_obj->x, source_obj->y);

// Get the ssector

pssector new_ss=Get_Object_SSector(source_obj, starting_node_index);

// Have we changed sub sectors?

if (new_ss!=source_obj->cur_ss) {

  // Then move object from one sub sectors draw list to another's

  OL_Delete_Node(source_obj->ss_node, source_obj->cur_ss->objects);
  source_obj->cur_ss->num_objects--;
  OL_Push_Node(source_obj->ss_node,new_ss->objects);
  new_ss->num_objects++;

  source_obj->cur_ss=new_ss;

  // Have we changed sectors?

  psector new_sec=Get_Sec_From_SSec(new_ss);
  if (new_sec!=source_obj->cur_sec) {

     // Then update object's sector z value

     source_obj->type->Update_Z(source_obj, new_sec);

     source_obj->cur_sec=new_sec;

  }

}

return 0;
}

void Do_Move_Correction(pvector2 input_source_vec, pvector2 delta_vec) {

vector2 source_vec, base_vec, old_vec;
short cur_block_x, cur_block_y, dest_block_x, dest_block_y, next_block_x, next_block_y;
long next_x_line, next_y_line, dist_major, dist_minor;

source_vec.x=input_source_vec->x;
source_vec.y=input_source_vec->y;
base_vec.x=source_vec.x;
base_vec.y=source_vec.y;
old_vec.x=base_vec.x;
old_vec.y=base_vec.y;

FOREVER {

   Do_Block_Correction(cur_block_x, cur_block_y, NULL,NULL,dist_major);

   if ( (base_vec.x!=old_vec.x) || (base_vec.y!=old_vec.y) ) {
      old_vec.x=base_vec.x;
      old_vec.y=base_vec.y;
      source_vec.x=base_vec.x;
      source_vec.y=base_vec.y;
      cur_block_x=Block_X(source_vec.x);
      cur_block_y=Block_Y(source_vec.y);
   }

   dest_block_x=Block_X(base_vec.x+delta_vec->x);
   dest_block_y=Block_Y(base_vec.y+delta_vec->y);

   if ( (cur_block_x==dest_block_x) && (cur_block_y==dest_block_y) ) { 
      break;
   }

   if (delta_vec->x >= 0) {
      next_block_x=cur_block_x+1;
      next_x_line=Block_Right_Line(source_vec.x);
   } else {
      next_block_x=cur_block_x-1;
      next_x_line=Block_Left_Line(source_vec.x);
   }

   if (delta_vec->y >= 0) {
      next_block_y=cur_block_y+1;
      next_y_line=Block_Top_Line(source_vec.y);
   } else {
      next_block_y=cur_block_y-1;
      next_y_line=Block_Bottom_Line(source_vec.y);
   }

   if (ABS(delta_vec->x)>ABS(delta_vec->y)) {
      
      dist_minor=(next_y_line-source_vec.y)<<SHIFT;
      dist_major=fixedmd((next_x_line-source_vec.x)<<SHIFT, 
         delta_vec->y, delta_vec->x); 
      
      if (ABS(dist_major)<ABS(dist_minor)) {
         source_vec.x=next_x_line;
         source_vec.y+=(dist_major>>SHIFT);
         cur_block_x=next_block_x;
      } else {
         source_vec.y=next_y_line;
         source_vec.x+=fixedmd(dist_minor, delta_vec->x, delta_vec->y)>>SHIFT;
         cur_block_y=next_block_y;
      }

   } else {
   
      dist_minor=(next_x_line-source_vec.x)<<SHIFT;
      dist_major=fixedmd((next_y_line-source_vec.y)<<SHIFT, 
         delta_vec->x, delta_vec->y); 
      
      if (ABS(dist_major)<ABS(dist_minor)) {
         source_vec.y=next_y_line;
         source_vec.x+=(dist_major>>SHIFT);
         cur_block_y=next_block_y;
      } else {
         source_vec.x=next_x_line;
         source_vec.y+=fixedmd(dist_minor, delta_vec->y, delta_vec->x)>>SHIFT;
         cur_block_x=next_block_x;
      }

   }

}  

// make delta's from original position
delta_vec->x=(source_vec.x+delta_vec->x)-input_source_vec->x;
delta_vec->y=(source_vec.y+delta_vec->y)-input_source_vec->y;
}

void Do_Block_Correction(short block_x,
   short block_y, pvector2 dest_vec, plinedef closest_line, MYFIXED & min_dis)
{
   pline_list cur_line_list;
   plinedef cur_line;
   short cur_line_index;
   long x1,x2,y1,y2, dest_dis, line_relation, line_dis;

   cur_line_list=Get_Block_Line_List(block_x, block_y);

      closest_line=NULL;

      for (cur_line_index=0; cur_line_index< cur_line_list->line_count; cur_line_index++) {
 
         cur_line=cur_line_list->lines[cur_line_index];
         x1=Vector_List[cur_line->v[0]].x;
         y1=Vector_List[cur_line->v[0]].y;
         x2=Vector_List[cur_line->v[1]].x;
         y2=Vector_List[cur_line->v[1]].y;
         //line_dis=cur_line->distance;

         line_relation=fixeddiv( ((y1-y2)*(y1-dest_vec->y)-(x2-x1)*(x1-dest_vec->x)) << SHIFT,
                fixedmult(line_dis,line_dis));
         if (line_relation<0 || line_relation>ONE)
            dest_dis=MAX_LINE_DIS;
         else {
            dest_dis=fixeddiv(((x2-x1)*(dest_vec->y-y2)-(y1-y2)*(dest_vec->x-x2))<<SHIFT, line_dis);
         }

         // have we found a closer intersecting line?
         if (dest_dis<min_dis) {
            closest_line=cur_line;
            min_dis=dest_dis;
            }

      } /* endfor */

}
  
