'
'Written by: Yann/Iguana
'      Date: 1/11/93
'

	PI2 = 2 * 3.131593
       
	NumFacets = 4 * 40
	SamplePoints = NumFacets + 1
	OutRadius = 10
	InRadius = 9
	Height = 1.5
       
	DIM PointsArray(2 * SamplePoints, 3)
	DIM FacetsArray%(NumFacets, 8)

	'Calc points' coordinates
	FOR r = 0 TO SamplePoints - 1
		Theta = r * PI2 / SamplePoints
		Theta4 = 4 * Theta
		PointsArray(2 * r, 0) = 256! * OutRadius * COS(Theta)
		PointsArray(2 * r, 1) = 256! * OutRadius * SIN(Theta)
		PointsArray(2 * r, 2) = 256! * Height * SIN(Theta4)
		PointsArray(2 * r + 1, 0) = 256! * InRadius * COS(Theta)
		PointsArray(2 * r + 1, 1) = 256! * InRadius * SIN(Theta)
		PointsArray(2 * r + 1, 2) = 256! * Height * SIN(Theta4)
	NEXT

	'Calc facets' data
	FOR r = 0 TO NumFacets
		FacetsArray%(r, 0) = 0             'Facet type
		FacetsArray%(r, 1) = 1 + 255 * RND + .5'Color
		FacetsArray%(r, 2) = 0             'Not used
		FacetsArray%(r, 3) = 4             '# of verts
		FacetsArray%(r, 4) = 2 * r
		FacetsArray%(r, 5) = 2 * r + 1
		FacetsArray%(r, 6) = 2 * r + 3
		FacetsArray%(r, 7) = 2 * r + 2
	NEXT r

	'write the numbers neatly to a file
	KILL "road.inc"
	OPEN "road.inc" FOR OUTPUT AS 1
	PRINT #1, "NUM_POINTS = "; : PRINT #1, USING "####"; CINT(2 * SamplePoints)
	PRINT #1, "WorldPts LABEL WORD"
	FOR r = 0 TO SamplePoints - 1
		PRINT #1, "  DW ";
		PRINT #1, USING "#####"; CINT(PointsArray(2 * r, 0));
		PRINT #1, ",";
		PRINT #1, USING "#####"; CINT(PointsArray(2 * r, 1));
		PRINT #1, ",";
		PRINT #1, USING "#####"; CINT(PointsArray(2 * r, 2));
		PRINT #1, ",";
		PRINT #1, USING "#####"; CINT(PointsArray(2 * r + 1, 0));
		PRINT #1, ",";
		PRINT #1, USING "#####"; CINT(PointsArray(2 * r + 1, 1));
		PRINT #1, ",";
		PRINT #1, USING "#####"; CINT(PointsArray(2 * r + 1, 2))
	NEXT r
	PRINT #1, "NUM_FACETS = "; : PRINT #1, USING "####"; CINT(NumFacets)
	PRINT #1, "Facets LABEL WORD"
	FOR r = 0 TO NumFacets - 1
		PRINT #1, "  DW ";
		FOR s = 0 TO 6
			PRINT #1, USING "#####"; CINT(FacetsArray%(r, s));
			PRINT #1, ",";
		NEXT s
		PRINT #1, USING "#####"; CINT(FacetsArray%(r, 7))
	NEXT r
	CLOSE #1



