#ifndef __OBJECTS_H
#define __OBJECTS_H

#include <xforms.h>

#ifdef __cplusplus
extern "C" {
#endif

/* #define __vertexnormals__ */
/* that last define enables vertex normals. these are used for shading
   objects using Gouraud or Phong shading, for example. Put it in comments
   if you want it out, put the comments in if you want it in */


struct point_struct
	{
	vector location;
#ifdef __vertexnormals__
	vector normal;
#endif
	long clipping;
	};


typedef struct point_struct point;


struct pointcollection_struct
	{
	point *vertex; /* array of vertices */
	long numpoints;
	};

typedef struct pointcollection_struct pointcollection;

struct face_struct
	{
	long *index; /* index to array of points, whatever */
	long numpoints;
	vector normal;
	REAL D; /* D component of plane eq. Ax+By+Cz=D */
	};

typedef struct face_struct face;

struct facecollection_struct
	{
	face *face;
	long numfaces;
	};

typedef struct facecollection_struct facecollection;


struct object_struct
	{
	pointcollection *pts_data;
	facecollection *face_data;
	long usecount; /* number of times this object has been cloned, see below */
	};

typedef struct object_struct object;

pointcollection *alloc_pointcollection(int numpoints);
	/* allocates a brand-new pointcollection with all associated data
	   allocated but uninitialized */
void free_pointcollection(pointcollection *p);
	/* frees an allocated pointcollection */

facecollection *alloc_facecollection(int numfaces);
	/* allocates a facecollection. note: does not allocate any
	   f->face[i].index, instead initializes them to 0 */

void free_facecollection(facecollection *f);
	/* frees an allocated facecollection. note: also frees all
	   f->face[i].index */

object *alloc_object(long numpoints, long numfaces);
void free_object(object *o);
	/* IBID */
object *clone_object(object *o);
	/* creates and returns a clone of object o. all data structures
	   are shared. the usecount is incremented. free_object is made
	   so that it first decrements usecount and only frees all memory
	   if usecount is zero */


int init_facepts(face *f, long numpoints);
	/* allocates memory for index and sets numpoints. return 0 on success,
	   nonzero on failure */


REAL compute_2area(face *f, point *p, int axis1, int axis2);
	/* computes the signed area of polygon projected on axis1 X axis2
	   plane. This is used to compute plane normal (it actually returns
	   twice the signed area) */

void init_normals(object *o);
	/* computes all plane normals then calls fix_D. also computes the
	   o->pts_data->vertex[...].clipping counters */

void normalize_object(object *o);
	/* makes all normals of unit length, then calls fix_D */

void fix_D(object *o);
	/* fixes all values for D if somehow they're messed */

int make_tetrahedron(object *o);
	/* given an object of 4 faces, 4 vertices, with initialized vertices
	   (the rest left uninitialized), this routine will make a
	   tetrahedron out of it. It will return 0 if everything is fine,
	   nonzero if the tetrahedron is degenerate (e.g. too slim). In this
	   latter case, it can still be used, but it might not look like a
	   tetrahedron at all. Example call to make_tetrahedron (RAND is
	   a function returning a random REAL value):

	   object *o;
	   long a,b;
	   o=alloc_object(4,4);
	   for(a=0;a<4;a++)
		   for(b=0;b<3;b++)
			   o->pts_data->vertex[a].location[b]=RAND();
	   make_tetrahedron(o);
	*/

#ifdef __cplusplus
}
#endif

#endif
