#ifndef __ZSORT_H
#define __ZSORT_H

#include <objects.h>

#ifdef __cplusplus
extern "C" {
#endif



struct pipe_point_struct
	{
	point point;
	REAL scr_X,scr_Y;
	};


typedef struct pipe_point_struct pipe_point;




/* Z sorting routines for visible surface determination */

struct pipeline_struct
	{
	pipe_point *pbase;
	face *fbase;
	long *ibase;
	long pptr,fptr,iptr;
	long numfaces, numpoints, numindex;
	long *index1, *index2, *maxZ, *minZ; /* sorting data */
	};



typedef struct pipeline_struct pipeline;


pipeline *alloc_pipeline(int numpoints, int numfaces, int numindex);
	/* allocates a pipeline and calls reset_pipeline */

void free_pipeline(pipeline *p);
	/* frees a pipeline */

void reset_pipeline(pipeline *p);
	/* empties the pipeline */


long *sort_pipeline(pipeline *p);
	/* z-sorts the pipeline and puts the result in one of the indexes,
	   returns pointer to index to sorted faces. */

void xform_pointcollection
	(pointcollection *p,
	 affine *xform,
	 pipe_point *xpoints);
	/* transforms a given pointcollection's points using the orientation
	   matrix and position vector (e.g. multiplies by rotation matrix then
	   adds position vector. points are outputted to the xpoints array */

void cull_object(object *o, pipeline *p, affine *xform);
	/* culls the object and outputs only the needed faces to the pipeline.
	   also performs the xform_pointcollection and stuff */



void bytesort(long *data, long *indexin, long *indexout, long itemcount,
			int bytenumber);
	/* for bytenumber values of 0 to 3, sorts the data according to
	   bytenumber in increasing values. Data is input in order of indexin
	   and output in order of indexout - note: this sort uses a temporary
	   array internally, allocated on the stack of course, of size
	   257*sizeof(long), so don't run this with a tiny weensy little stack */




#ifdef __cplusplus
}
#endif

#endif