VERSION 4.00
Begin VB.Form Form1
   BackColor       =   &H00FFFFFF&
   Caption         =   "Palette Fades"
   ClientHeight    =   4140
   ClientLeft      =   1140
   ClientTop       =   1800
   ClientWidth     =   6690
   Height          =   4830
   Left            =   1080
   LinkTopic       =   "Form1"
   ScaleHeight     =   4140
   ScaleWidth      =   6690
   Top             =   1170
   Width           =   6810
   Begin VB.Menu mnuFadeIn
      Caption         =   "Fade&In"
      Enabled         =   0   'False
   End
   Begin VB.Menu mnuFadeOut
      Caption         =   "Fade&Out"
   End
   Begin VB.Menu mnuQuit
      Caption         =   "&Quit"
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False

'*****************************************************************************
'                                                                            *
'  FADE.FRM                                                                  *
'                                                                            *
'  This program shows how perform a palette fade.                            *
'                                                                            *
'*****************************************************************************

Const vbWidth = 320
Const vbHeight = 200

Dim Original(236 * 3) As Byte
Dim Current(236 * 3) As Byte

Dim hPal As Long
Dim hvb As Long
Dim cxClient As Long, cyClient As Long

Private Sub Form_Activate()
   fg_realize (hPal)
   Refresh
End Sub

Private Sub Form_Load()
   ScaleMode = 3
   Call fg_setdc(hDC)
   hPal = fg_defpal()
   Call fg_realize(hPal)

   Call fg_vbinit
   hvb = fg_vballoc(vbWidth, vbHeight)
   Call fg_vbopen(hvb)
   Call fg_vbcolors

   Call fg_showpcx(CurDir + "\MOUSE.PCX", 2)
   Call fg_getdacs(10, 236, Original(1))
End Sub

Private Sub Form_Paint()
   Call fg_vbscale(0, vbWidth - 1, 0, vbHeight - 1, 0, cxClient - 1, 0, cyClient - 1)
End Sub

Private Sub Form_Resize()
   cxClient = ScaleWidth
   cyClient = ScaleHeight
   Refresh
End Sub

Private Sub Form_Unload(Cancel As Integer)
   Call fg_vbclose
   Call fg_vbfree(hvb)
   Call fg_vbfin
End Sub

Private Sub mnuFadeIn_Click()
   Dim I As Integer
   Dim Fading As Boolean

   Erase Current

   Do
      Fading = False
      For I = 1 To 236 * 3
         If Current(I) <> Original(I) Then
            Current(I) = Current(I) + 1
            Fading = True
         End If
      Next I
      Call fg_setdacs(10, 236, Current(1))
      If fg_colors > 8 Then
         Call fg_vbscale(0, vbWidth - 1, 0, vbHeight - 1, 0, cxClient - 1, 0, cyClient - 1)
      End If
   Loop While Fading

   mnuFadeIn.Enabled = False
   mnuFadeOut.Enabled = True
End Sub

Private Sub mnuFadeOut_Click()
   Dim I As Integer
   Dim Fading As Boolean

   For I = 1 To 236 * 3
      Current(I) = Original(I)
   Next I

   Do
      Fading = False
      For I = 1 To 236 * 3
         If Current(I) <> 0 Then
            Current(I) = Current(I) - 1
            Fading = True
         End If
      Next I
      Call fg_setdacs(10, 236, Current(1))
      If fg_colors > 8 Then
         Call fg_vbscale(0, vbWidth - 1, 0, vbHeight - 1, 0, cxClient - 1, 0, cyClient - 1)
      End If
   Loop While Fading

   mnuFadeOut.Enabled = False
   mnuFadeIn.Enabled = True
End Sub

Private Sub mnuQuit_Click()
   Unload Me
End Sub
