{*****************************************************************************
*                                                                            *
*  FADE.PAS                                                                  *
*                                                                            *
*  This program shows how perform a palette fade.                            *
*                                                                            *
*****************************************************************************}

program fade;

{$IFDEF VER80}
uses WinTypes, WinProcs, Messages, FGWinG;
{$ELSE}
uses WinTypes, WinProcs, FGWinG;
{$ENDIF}

const
  AppName = 'FGfade';
  WIDTH   = 320;
  HEIGHT  = 200;

  IDM_FADEIN  = 1;
  IDM_FADEOUT = 2;
  IDM_QUIT    = 3;

var
  cxClient, cyClient : word;
  dc   : hDC;
  menu : hMenu;
  hpal : hPalette;
  hvb  : integer;
  original : array [1..236*3] of byte;
  current  : array [1..236*3] of byte;

{*****************************************************************************
*                                                                            *
*  do_fadein                                                                 *
*                                                                            *
*  Fade an image back to its original colors.                                *
*                                                                            *
*****************************************************************************}

procedure do_fadein;

var
  i : integer;
  fading : boolean;

begin
  FillChar(current,236*3,0);
  fading := TRUE;

  while fading do
  begin
    fading := FALSE;
    for i := 1 to 236*3 do
    begin
      if (current[i] <> original[i]) then
      begin
        inc(current[i]);
        fading := TRUE;
      end;
    end;
    fg_setdacs(10,236,current);
    if (fg_colors > 8) then
        fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
  end;

  EnableMenuItem(menu,IDM_FADEIN,MF_GRAYED);
  EnableMenuItem(menu,IDM_FADEOUT,MF_ENABLED);
  DrawMenuBar(GetActiveWindow);
end;

{*****************************************************************************
*                                                                            *
*  do_fadeout                                                                *
*                                                                            *
*  Fade an image to black.                                                   *
*                                                                            *
*****************************************************************************}

procedure do_fadeout;

var
  i : integer;
  fading : boolean;

begin
  Move(original,current,236*3);
  fading := TRUE;

  while fading do
  begin
    fading := FALSE;
    for i := 1 to 236*3 do
    begin
      if (current[i] <> 0) then
      begin
        dec(current[i]);
        fading := TRUE;
      end;
    end;
    fg_setdacs(10,236,current);
    if (fg_colors > 8) then
        fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
  end;

  EnableMenuItem(menu,IDM_FADEOUT,MF_GRAYED);
  EnableMenuItem(menu,IDM_FADEIN,MF_ENABLED);
  DrawMenuBar(GetActiveWindow);
end;

{*****************************************************************************
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
*****************************************************************************}

function WindowProc(window : hwnd; message : word;
                    wParam : word; lParam : longint): longint; export;
var
  ps : tPaintStruct;

begin

  WindowProc := 0;

  case message of

    WM_CREATE:
    begin
      dc := GetDC(window);
      fg_setdc(dc);
      hpal := fg_defpal;
      fg_realize(hpal);

      fg_vbinit;
      hvb := fg_vballoc(WIDTH,HEIGHT);
      fg_vbopen(hvb);
      fg_vbcolors;

      fg_showpcx('MOUSE.PCX'+chr(0),2);
      fg_getdacs(10,236,original);

      menu := GetMenu(window);
      Exit;
    end;

    WM_COMMAND:
    begin
      case wParam of
        IDM_FADEIN:
        begin
          do_fadein;
          Exit;
        end;

        IDM_FADEOUT:
        begin
          do_fadeout;
          Exit;
        end;

        IDM_QUIT:
        begin
          SendMessage(window,WM_CLOSE,0,0);
          Exit;
        end;
      end;
    end;

    WM_PAINT:
    begin
      BeginPaint(window,ps);
      fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
      EndPaint(window,ps);
      Exit;
    end;

    WM_SETFOCUS:
    begin
      fg_realize(hpal);
      InvalidateRect(window,nil,TRUE);
      Exit;
    end;

    WM_SIZE:
    begin
      cxClient := LOWORD(lParam);
      cyClient := HIWORD(lParam);
      Exit;
    end;

    WM_DESTROY:
    begin
      fg_vbclose;
      fg_vbfree(hvb);
      fg_vbfin;
      DeleteObject(hpal);
      ReleaseDC(window,dc);
      PostQuitMessage(0);
      Exit;
    end;

  end;
  WindowProc := DefWindowProc(window,message,wParam,lParam);
end;

{****************************************************************************}

procedure WinMain;

var
  window      : hWnd;
  message     : tMsg;
  WindowClass : tWndClass;

begin
  if hPrevInst = 0 then
  begin
    WindowClass.style         := CS_HREDRAW OR CS_VREDRAW;
    WindowClass.lpfnWndProc   := @WindowProc;
    WindowClass.cbClsExtra    := 0;
    WindowClass.cbWndExtra    := 0;
    WindowClass.hInstance     := hInstance;
    WindowClass.hIcon         := LoadIcon(0,IDI_APPLICATION);
    WindowClass.hCursor       := LoadCursor(0,IDC_ARROW);
    WindowClass.hbrBackground := GetStockObject(WHITE_BRUSH);
    WindowClass.lpszMenuName  := AppName;
    WindowClass.lpszClassName := AppName;
    if not RegisterClass(WindowClass) then Halt(255);
  end;

  window := CreateWindow(
    AppName,                    { window class name }
    'Palette Fades',            { window caption }
    WS_OVERLAPPEDWINDOW,        { window style }
    CW_USEDEFAULT,              { initial x position }
    CW_USEDEFAULT,              { initial y position }
    CW_USEDEFAULT,              { initial x size }
    CW_USEDEFAULT,              { initial y size }
    0,                          { parent window handle }
    0,                          { window menu handle }
    hInstance,                  { program instance handle }
    nil);                       { creation parameters }

  ShowWindow(window,CmdShow);
  UpdateWindow(window);

  while GetMessage(message,0,0,0) do
  begin
    TranslateMessage(message);
    DispatchMessage(message);
  end;

  Halt(message.wParam);
end;

begin
  WinMain;
end.
