{*****************************************************************************
*                                                                            *
*  FADE.DPR                                                                  *
*  FADEU.PAS                                                                 *
*                                                                            *
*  This program shows how perform a palette fade.                            *
*                                                                            *
*****************************************************************************}

unit FadeU;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWin, Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    FadeIn1: TMenuItem;
    FadeOut1: TMenuItem;
    Quit1: TMenuItem;
    procedure AppOnActivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FadeIn(Sender: TObject);
    procedure FadeOut(Sender: TObject);
    procedure Quit(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
const
  VBWIDTH  = 320;
  VBHEIGHT = 200;

var
  cxClient, cyClient : integer;
  dc   : hDC;
  hpal : hPalette;
  hvb  : integer;
  original : array [1..236*3] of byte;
  current  : array [1..236*3] of byte;

{*****************************************************************************
*                                                                            *
*  do_fadein                                                                 *
*                                                                            *
*  Fade an image back to its original colors.                                *
*                                                                            *
*****************************************************************************}

procedure do_fadein;

var
  i : integer;
  fading : boolean;

begin
  FillChar(current,236*3,0);
  fading := TRUE;

  while fading do
  begin
    fading := FALSE;
    for i := 1 to 236*3 do
    begin
      if (current[i] <> original[i]) then
      begin
        inc(current[i]);
        fading := TRUE;
      end;
    end;
    fg_setdacs(10,236,current);
    if (fg_colors > 8) then
      fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
  end;

  Form1.FadeIn1.Enabled  := False;
  Form1.FadeOut1.Enabled := True;
end;

{*****************************************************************************
*                                                                            *
*  do_fadeout                                                                *
*                                                                            *
*  Fade an image to black.                                                   *
*                                                                            *
*****************************************************************************}

procedure do_fadeout;

var
  i : integer;
  fading : boolean;

begin
  Move(original,current,236*3);
  fading := TRUE;

  while fading do
  begin
    fading := FALSE;
    for i := 1 to 236*3 do
    begin
      if (current[i] <> 0) then
      begin
        dec(current[i]);
        fading := TRUE;
      end;
    end;
    fg_setdacs(10,236,current);
    if (fg_colors > 8) then
      fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
  end;

  Form1.FadeIn1.Enabled  := True;
  Form1.FadeOut1.Enabled := False;
end;

{****************************************************************************}

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  fg_vbinit;
  hvb := fg_vballoc(VBWIDTH,VBHEIGHT);
  fg_vbopen(hvb);
  fg_vbcolors;

  fg_showpcx('MOUSE.PCX'+chr(0),2);
  fg_getdacs(10,236,original);

  Application.OnActivate := AppOnActivate;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  cxClient := ClientWidth;
  cyClient := ClientHeight;
  Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb);
  fg_vbfin;
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

procedure TForm1.FadeIn(Sender: TObject);
begin
  do_fadein;
end;

procedure TForm1.FadeOut(Sender: TObject);
begin
  do_fadeout;
end;

procedure TForm1.Quit(Sender: TObject);
begin
  Halt(1);
end;

end.
