/****************************************************************************\
*                                                                            *
*  FGGIF.H                                                                   *
*                                                                            *
*  This file contains the C and C++ function prototypes for the Fastgraph    *
*  5.0 freeware GIF library.                                                 *
*                                                                            *
*  Copyright (c) 1991-1997 Ted Gruber Software.  All rights reserved.        *
*                                                                            *
\****************************************************************************/

#ifndef __FGGIF_H

#define __FGGIF_H
#define FGGIF_CDECL

#ifdef __HIGHC__           /* MetaWare High C/C++ */
#pragma Global_aliasing_convention("_%r")
#endif

#ifdef __WATCOMC__         /* WATCOM C/C++ (16-bit and 32-bit versions) */
#undef  FGGIF_CDECL
#define FGGIF_CDECL __cdecl
#endif

#ifdef __cplusplus
extern "C" {
#endif

int  FGGIF_CDECL fg_gifhead (char *, char *);
int  FGGIF_CDECL fg_gifmode (char *);
int  FGGIF_CDECL fg_gifpal (char *, char *);
void FGGIF_CDECL fg_gifrange (char *, int *, int *, int *, int *);
int  FGGIF_CDECL fg_makegif (int, int, int, int, char *);
int  FGGIF_CDECL fg_showgif (char *, int);
int  FGGIF_CDECL fgi_showgif (char *, int, int);

#ifdef __HIGHC__           /* MetaWare High C/C++ */
#pragma Global_aliasing_convention()
#endif

#ifdef __cplusplus
}
#endif

#endif                     /* of #ifndef __FGGIF_H */
