REM $INCLUDE: 'fastgraf.bi'

DEFINT A-Z

CONST VBwidth = 1000
CONST VBheight = 50

REM initialize the video environment

OldMode = FGgetmode
FGsetmode 20
FGvbinit

REM fill the screen with light blue pixels

FGsetcolor 9
FGfillpage

REM set up the virtual buffer

SetMemStatus& = SETMEM(-(CLNG(VBwidth)*CLNG(VBheight)+16))
Handle = FGvballoc(VBwidth,VBheight)
IF Handle < 0 THEN
   FGsetmode OldMode
   FGreset
   PRINT "Could not create the virtual buffer."
   STOP
END IF
Status = FGvbopen(Handle)

REM fill the virtual buffer with a series of narrow rectangles

FOR X = 0 TO VBwidth-1
   FGsetcolor X
   FGrect X, X, 0, VBheight-1
NEXT

REM scroll the virtual buffer through a 100x50 window on the
REM visual page, such that the top half scrolls left and the
REM bottom half scrolls right

FOR X = 0 TO VBwidth-100
   FGvbpaste X, X+99, 0, 24, 110, 99
   FGvbpaste VBwidth-100-X, VBwidth-1-X, 25, 49, 110, 124
NEXT
FGwaitkey

REM close the virtual buffer

FGvbclose
FGvbfree Handle

REM restore original video mode and exit

FGsetmode OldMode
FGreset
END
