REM $INCLUDE: 'fastgraf.bi'

DEFINT A-Z

REM initialize the video environment

FGsetmode 20

REM define a processor-dependent panning delay

Delay = FGmeasure / 16

REM draw a blue box with a white border on page 1

FGsetpage 1
FGsetcolor 9
FGfillpage
FGsetcolor 15
FGbox 0, 319, 0, 199
FGmove 160, 100
FGjustify 0, 0
FGprint "This is page 1", 14

REM display what we just drew on page 1

FGsetvpage 1
FGwaitkey

REM draw a red hollow box at the top of page 0 (now invisible)

FGsetpage 0
FGsetcolor 12
FGbox 0, 319, 0, 19
FGsetcolor 15
FGmove 160, 10
FGprint "SPLIT SCREEN", 12

REM activate the split screen environment, making the first 20 lines  
REM of page 0 appear at the bottom of the screen, and making the first
REM 180 lines of page 1 appear at the top                             

FGsplit 180
FGwaitkey

REM pan upward in one-line increments, displaying the rest of page 1

FGsetpage 1
FOR Y = 0 TO 20
   FGpan 0, Y
   FGstall Delay
NEXT
FGwaitkey

REM pan back down in one-line increments to the original position

FOR Y = 20 TO 0 STEP -1
   FGpan 0, Y
   FGstall Delay
NEXT
FGwaitkey

REM restore 80x25 text mode and exit

FGsetmode 3
FGreset
END
