{$M 16384,0,0}

program main;
uses fgmain, fgbitmap, fgmisc;

const
  PAGES = 4;

var
  old_mode : integer;
  new_mode : integer;
  page     : integer;
  status   : integer;
  message  : string[8];

begin
  fg_initpm;
  new_mode := fg_bestmode(80,25,PAGES);
  if (new_mode < 0) then
  begin
    write('This program requires ');
    writeln('an 80-column display.');
    exit;
  end;

  old_mode := fg_getmode;
  fg_setmode(new_mode);
  fg_cursor(0);

  for page := 0 to PAGES-1 do
  begin
    status := fg_allocate(page);
    fg_setpage(page);
    fg_setcolor(7);
    fg_rect(0,fg_getmaxx,0,fg_getmaxy);
    fg_setattr(0,7,0);
    fg_locate(12,37);
    str(page,message);
    fg_text('page '+message,6);
  end;

  for page := 0 to PAGES-1 do
  begin
    fg_setvpage(page);
    fg_waitkey;
    status := fg_freepage(page);
  end;

  fg_setmode(old_mode);
  fg_reset;
end.
