{$M 16384,0,0}

program main;
uses fgmain, fgbitmap, fgmisc;

const
  PAGES = 4;

var
  old_mode : integer;
  new_mode : integer;
  page     : integer;
  status   : integer;
  message  : string[8];

begin
  fg_initpm;
  new_mode := fg_bestmode(320,200,PAGES);
  if (new_mode < 0) then
  begin
    write('This program requires a ');
    writeln('320 x 200 graphics mode.');
    exit;
  end;

  old_mode := fg_getmode;
  fg_setmode(new_mode);

  for page := 0 to PAGES-1 do
  begin
    status := fg_allocate(page);
    fg_setpage(page);
    fg_setcolor(15);
    fg_rect(0,fg_getmaxx,0,fg_getmaxy);
    fg_setcolor(0);
    fg_locate(12,17);
    str(page,message);
    fg_text('page '+message,6);
  end;

  for page := 0 to PAGES-1 do
  begin
    fg_setvpage(page);
    fg_waitkey;
  end;

  for page := 0 to PAGES-1 do
    status := fg_freepage(page);

  fg_setmode(old_mode);
  fg_reset;
end.
