program main;
{$IFDEF DPMI}
uses fgmain, fgmisc, fgvb, WinAPI;
{$ELSE}
{$M 16384,0,16384}
uses fgmain, fgmisc, fgvb;
{$ENDIF}

const
  WIDTH = 640;
  HEIGHT = 400;

var
  handle   : integer;
  old_mode : integer;
  status   : integer;
  buffer   : pointer;

begin

  { initialize the video environment }

  fg_initpm;
  old_mode := fg_getmode;
  fg_setmode(19);
  fg_vbinit;

  { set up a 640x400 virtual buffer }

{$IFDEF DPMI}
  buffer := GlobalAllocPtr(gmem_Fixed,Longint(WIDTH)*Longint(HEIGHT));
  if (buffer = NIL) then
  begin
    fg_setmode(old_mode);
    fg_reset;
    writeln('Could not create the virtual buffer.');
    exit;
  end;
  handle := fg_vbdefine(buffer,WIDTH,HEIGHT);
{$ELSE}
  handle := fg_vballoc(WIDTH,HEIGHT);
  if (handle < 0) then
  begin
    fg_setmode(old_mode);
    fg_reset;
    writeln('Could not create the virtual buffer.');
    exit;
  end;
{$ENDIF}
  status := fg_vbopen(handle);

  { draw a 320x200 rectangle in each virtual buffer quadrant }

  fg_setcolor(9);
  fg_rect(0,319,0,199);
  fg_setcolor(10);
  fg_rect(320,639,0,199);
  fg_setcolor(11);
  fg_rect(0,319,200,399);
  fg_setcolor(12);
  fg_rect(320,639,200,399);

  { paste each rectangle to the 320x200 active video page }

  fg_vbpaste(0,319,0,199,0,199);
  fg_waitkey;
  fg_vbpaste(320,639,0,199,0,199);
  fg_waitkey;
  fg_vbpaste(0,319,200,399,0,199);
  fg_waitkey;
  fg_vbpaste(320,639,200,399,0,199);
  fg_waitkey;

  { paste the center 320x200 subset of the virtual buffer }

  fg_vbpaste(160,479,100,299,0,199);
  fg_waitkey;

  { close the virtual buffer }

  fg_vbclose;
{$IFDEF dpmi}
  GlobalFreePtr(buffer);
{$ELSE}
  fg_vbfree(handle);
{$ENDIF}

  { restore original video mode and exit }

  fg_setmode(old_mode);
  fg_reset;
end.
