program main;
{$IFDEF DPMI}
uses fgmain, fgmisc, fgvb, WinAPI;
{$ELSE}
{$M 16384,0,16384}
uses fgmain, fgmisc, fgvb;
{$ENDIF}

const
  WIDTH = 1000;
  HEIGHT = 50;

var
  handle   : integer;
  old_mode : integer;
  status   : integer;
  x        : integer;
  buffer   : pointer;

begin

  { initialize the video environment }

  fg_initpm;
  old_mode := fg_getmode;
  fg_setmode(20);
  fg_vbinit;

  { fill the screen with light blue pixels }

  fg_setcolor(9);
  fg_fillpage;

  { set up the virtual buffer }

{$IFDEF DPMI}
  buffer := GlobalAllocPtr(gmem_Fixed,Longint(WIDTH)*Longint(HEIGHT));
  if (buffer = NIL) then
  begin
    fg_setmode(old_mode);
    fg_reset;
    writeln('Could not create the virtual buffer.');
    exit;
  end;
  handle := fg_vbdefine(buffer,WIDTH,HEIGHT);
{$ELSE}
  handle := fg_vballoc(WIDTH,HEIGHT);
  if (handle < 0) then
  begin
    fg_setmode(old_mode);
    fg_reset;
    writeln('Could not create the virtual buffer.');
    exit;
  end;
{$ENDIF}
  status := fg_vbopen(handle);

  { fill the virtual buffer with a series of narrow rectangles }

  for x := 0 to WIDTH-1 do
  begin
    fg_setcolor(x);
    fg_rect(x,x,0,HEIGHT-1);
  end;

  { scroll the virtual buffer through a 100x50 window on the }
  { visual page, such that the top half scrolls left and the }
  { bottom half scrolls right }

  for x := 0 to WIDTH-100 do
  begin
    fg_vbpaste(x,x+99,0,24,110,99);
    fg_vbpaste(WIDTH-100-x,WIDTH-1-x,25,49,110,124);
  end;
  fg_waitkey;

  { close the virtual buffer }

  fg_vbclose;
{$IFDEF dpmi}
  GlobalFreePtr(buffer);
{$ELSE}
  fg_vbfree(handle);
{$ENDIF}

  { restore original video mode and exit }

  fg_setmode(old_mode);
  fg_reset;
end.
