program main;
{$IFDEF DPMI}
uses fgmain, fgbitmap, fgmisc, fgvb, WinAPI;
{$ELSE}
{$M 16384,0,16384}
uses fgmain, fgbitmap, fgmisc, fgvb;
{$ENDIF}

var
  handle   : integer;
  old_mode : integer;
  status   : integer;
  buffer   : pointer;

begin
  fg_initpm;
  old_mode := fg_getmode;
  fg_setmode(22);
  fg_vbinit;

{$IFDEF DPMI}
  buffer := GlobalAllocPtr(gmem_Fixed,Longint(320)*Longint(240));
  if (buffer = NIL) then
  begin
    fg_setmode(old_mode);
    fg_reset;
    writeln('Could not create the virtual buffer.');
    exit;
  end;
  handle := fg_vbdefine(buffer,320,240);
{$ELSE}
  handle := fg_vballoc(320,240);
  if (handle < 0) then
  begin
    fg_setmode(old_mode);
    fg_reset;
    writeln('Could not create the virtual buffer.');
    exit;
  end;
{$ENDIF}

  fg_setcolor(9);
  fg_fillpage;
  fg_setcolor(15);
  fg_box(0,319,0,239);
  status := fg_vbopen(handle);
  fg_vbcut(0,319,0,239,0,239);
  fg_vbclose;
  fg_waitkey;

  fg_setmode(old_mode);
  fg_cursor(0);
  fg_setcolor(15);
  fg_text('Press any key.',14);
  fg_waitkey;

  fg_setmode(22);
  status := fg_vbopen(handle);
  fg_vbpaste(0,319,0,239,0,239);
  fg_waitkey;

  fg_vbclose;
{$IFDEF dpmi}
  GlobalFreePtr(buffer);
{$ELSE}
  fg_vbfree(handle);
{$ENDIF}
  fg_setmode(old_mode);
  fg_reset;
end.
