program main;
{$IFDEF DPMI}
uses fgmain, fgmisc, fgpcx, fgvb, WinAPI;
{$ELSE}
{$M 16384,0,16384}
uses fgmain, fgmisc, fgpcx, fgvb;
{$ENDIF}

var
  handle   : integer;
  old_mode : integer;
  status   : integer;
  buffer   : pointer;

begin
  fg_initpm;
  if (fg_testmode(19,1) = 0) then
  begin
    write('This program requires a 320 ');
    writeln('x 200 MCGA graphics mode.');
    exit;
  end;
  old_mode := fg_getmode;
  fg_setmode(19);
  fg_vbinit;

{$IFDEF DPMI}
  buffer := GlobalAllocPtr(gmem_Fixed,Longint(64000));
  if (buffer = NIL) then
  begin
    fg_setmode(old_mode);
    fg_reset;
    writeln('Could not create the virtual buffer.');
    exit;
  end;
  handle := fg_vbdefine(buffer,320,200);
{$ELSE}
  handle := fg_vballoc(320,200);
  if (handle < 0) then
  begin
    fg_setmode(old_mode);
    fg_reset;
    writeln('Could not create the virtual buffer.');
    exit;
  end;
{$ENDIF}
  status := fg_vbopen(handle);

  status := fg_loadpcx('CORAL.PCX'+chr(0),0);
  if (status = 0) then
  begin
    fg_vbpaste(0,319,0,199,0,199);
    fg_waitkey;
  end;

  fg_vbclose;
{$IFDEF dpmi}
  GlobalFreePtr(buffer);
{$ELSE}
  fg_vbfree(handle);
{$ENDIF}
  fg_setmode(old_mode);
  fg_reset;

  if (status = 1) then
    writeln('CORAL.PCX not found.')
  else if (status = 2) then
    writeln('CORAL.PCX is not a PCX file.');
end.
