{$M 16384,0,0}

program main;
uses fgmain, fgmisc;

const
  VISUAL = 0;
  HIDDEN = 1;

  xmin : array [0..11] of integer =
            ( 0, 96,192,  0, 96,192,  0, 96,192,  0, 96,192);
  ymax : array [0..11] of integer =
            (49, 49, 49, 99, 99, 99,149,149,149,199,199,199);

var
   status   : integer;
   new_mode : integer;
   old_mode : integer;
   frame, offset : integer;
   i, x, y : integer;

begin

  { initialize the video environment }

  fg_initpm;
  new_mode := fg_bestmode(320,200,2);
  if (new_mode < 0) or (new_mode = 12) then
  begin
    write('This program requires a 320 ');
    writeln('x 200 color graphics mode.');
    exit;
  end;
  old_mode := fg_getmode;
  fg_setmode(new_mode);
  status := fg_allocate(HIDDEN);

  { draw the background in the upper left corner }

  fg_setpage(HIDDEN);
  fg_setcolor(1);
  fg_rect(0,95,0,49);
  fg_setcolor(15);
  fg_move(48,25);
  fg_ellipse(20,20);

  { display the animated object against each background }

  fg_setcolor(10);
  offset := -10;
  for i := 1 to 11 do
  begin
    x := xmin[i];
    y := ymax[i];
    fg_transfer(0,95,0,49,x,y,HIDDEN,HIDDEN);
    fg_setclip(x,x+95,0,199);
    fg_clprect(x+offset,x+offset+19,y-29,y-20);
    inc(offset,10);
  end;

  { slide the object across the background three times }

  for i := 0 to 35 do
  begin
    frame := i mod 12;
    x := xmin[frame];
    y := ymax[frame];
    fg_transfer(x,x+95,y-49,y,112,124,HIDDEN,VISUAL);
    fg_waitfor(2);
  end;

  { restore the original video mode and return to DOS }

  status := fg_freepage(HIDDEN);
  fg_setmode(old_mode);
  fg_reset;
end.
