{$M 16384,0,0}

program main;
uses fgmain, fgmisc;

const
  VISUAL = 0;
  HIDDEN = 1;

var
  status   : integer;
  new_mode : integer;
  old_mode : integer;
  frame, offset, i : integer;

begin

  { initialize the video environment }

  fg_initpm;
  new_mode := fg_bestmode(320,200,2);
  if (new_mode < 0) or (new_mode = 12) then
  begin
    write('This program requires a 320 ');
    writeln('x 200 color graphics mode.');
    exit;
  end;
  old_mode := fg_getmode;
  fg_setmode(new_mode);
  status := fg_allocate(HIDDEN);

  { draw the background in the upper left corner }

  fg_setpage(HIDDEN);
  fg_setcolor(1);
  fg_rect(0,95,0,49);
  fg_setcolor(15);
  fg_move(48,25);
  fg_ellipse(20,20);

  { copy it to the center of the visual page }

  fg_transfer(0,95,0,49,112,124,HIDDEN,VISUAL);

  { slide the object across the background three times }

  fg_setcolor(10);
  for i := 0 to 35 do
  begin
    frame  := i mod 12;
    offset := 10 * frame - 10;
    fg_transfer(0,95,20,29,112,105,HIDDEN,HIDDEN);
    fg_rect(112+offset,131+offset,96,105);
    fg_transfer(112,207,96,105,112,105,HIDDEN,VISUAL);
    fg_waitfor(2);
  end;

  { restore the original video mode and return to DOS }

  status := fg_freepage(HIDDEN);
  fg_setmode(old_mode);
  fg_reset;
end.
