program main;
{$IFDEF DPMI}
uses fgmain, fgbitmap, fgmisc, fgpcx, fgvb, WinAPI;
{$ELSE}
{$M 16384,0,16384}
uses fgmain, fgbitmap, fgmisc, fgpcx, fgvb;
{$ENDIF}

var
  key, aux : byte;
  handle   : integer;
  old_mode : integer;
  status   : integer;
  x, y     : integer;
  buffer   : pointer;

begin
  fg_initpm;
  old_mode := fg_getmode;
  fg_setmode(19);

  fg_vbinit;
{$IFDEF DPMI}
  buffer := GlobalAllocPtr(gmem_Fixed,Longint(64000));
  if (buffer = NIL) then
  begin
    fg_setmode(old_mode);
    fg_reset;
    writeln('Could not create the virtual buffer.');
    exit;
  end;
  handle := fg_vbdefine(buffer,320,200);
{$ELSE}
  handle := fg_vballoc(320,200);
  if (handle < 0) then
  begin
    fg_setmode(old_mode);
    fg_reset;
    writeln('Could not create the virtual buffer.');
    exit;
  end;
{$ENDIF}
  status := fg_vbopen(handle);
  status := fg_loadpcx('CORAL.PCX'+chr(0),0);
  fg_vbclose;

  fg_setcolor(2);
  fg_fillpage;
  fg_setcolor(15);
  fg_box(111,208,69,130);
  fg_locate(3,8);
  fg_text('Press arrow keys to pan.',24);

  x := 112;
  y := 129;
  fg_vbpaste(x,x+95,y-59,y,112,129);

  repeat
  begin
    fg_getkey(key,aux);
    if (aux = 72) and (y < 199) then
      inc(y)
    else if (aux = 75) and (x < 223) then
      inc(x)
    else if (aux = 77) and (x > 0) then
      dec(x)
    else if (aux = 80) and (y > 59) then
      dec(y);
    fg_vbpaste(x,x+95,y-59,y,112,129);
  end;
  until (key = 27);

{$IFDEF dpmi}
  GlobalFreePtr(buffer);
{$ELSE}
  fg_vbfree(handle);
{$ENDIF}
  fg_setmode(old_mode);
  fg_reset;
end.
