program main;
uses fgmain, fgbitmap, fgmisc;

var
  delay, y : integer;

begin

  { initialize the video environment }

  fg_initpm;
  fg_setmode(20);

  { define a processor-dependent panning delay }

  delay := fg_measure div 16;

  { draw a blue box with a white border on page 1 }

  fg_setpage(1);
  fg_setcolor(9);
  fg_fillpage;
  fg_setcolor(15);
  fg_box(0,319,0,199);
  fg_move(160,100);
  fg_justify(0,0);
  fg_print('This is page 1',14);

  { display what we just drew on page 1 }

  fg_setvpage(1);
  fg_waitkey;

  { draw a red hollow box at the top of page 0 (now invisible) }

  fg_setpage(0);
  fg_setcolor(12);
  fg_box(0,319,0,19);
  fg_setcolor(15);
  fg_move(160,10);
  fg_print('SPLIT SCREEN',12);

  { activate the split screen environment, making the first 20 lines   }
  { of page 0 appear at the bottom of the screen, and making the first }
  { 180 lines of page 1 appear at the top                              }

  fg_split(180);
  fg_waitkey;

  { pan upward in one-line increments, displaying the rest of page 1 }

  fg_setpage(1);
  for y := 0 to 20 do
  begin
    fg_pan(0,y);
    fg_stall(delay);
  end;
  fg_waitkey;

  { pan back down in one-line increments to the original position }

  for y := 20 downto 0 do
  begin
    fg_pan(0,y);
    fg_stall(delay);
  end;
  fg_waitkey;

  { restore 80x25 text mode and exit }

  fg_setmode(3);
  fg_reset;
end.
