$INCLUDE: 'C:\FG\FASTGRAF.FI'

      PROGRAM MAIN

      INTEGER WIDTH, HEIGHT
      PARAMETER (WIDTH = 1000, HEIGHT = 50)

      INTEGER HANDLE, OLD_MODE, STATUS, X
      INTEGER FG_GETMODE, FG_VBALLOC, FG_VBOPEN

C  Initialize the video environment

      CALL FG_INITPM
      OLD_MODE = FG_GETMODE()
      CALL FG_SETMODE(20)
      CALL FG_VBINIT

C  Fill the screen with light blue pixels

      CALL FG_SETCOLOR(9)
      CALL FG_FILLPAGE

      HANDLE = FG_VBALLOC(WIDTH,HEIGHT)
      IF (HANDLE .LT. 0) THEN
        CALL FG_SETMODE(OLD_MODE)
        CALL FG_RESET
        STOP 'Could not create the virtual buffer.'
      END IF
      STATUS = FG_VBOPEN(HANDLE)

C  Fill the virtual buffer with a series of narrow rectangles

      DO 10 X = 0,WIDTH-1
         CALL FG_SETCOLOR(X)
         CALL FG_RECT(X,X,0,HEIGHT-1)
10    CONTINUE

C  Scroll the virtual buffer through a 100x50 window on the
C  visual page, such that the top half scrolls left and the
C  bottom half scrolls right

      DO 20 X = 0,WIDTH-100
         CALL FG_VBPASTE(X,X+99,0,24,110,99)
         CALL FG_VBPASTE(WIDTH-100-X,WIDTH-1-X,25,49,110,124)
20    CONTINUE
      CALL FG_WAITKEY

C  Close the virtual buffer

      CALL FG_VBCLOSE
      CALL FG_VBFREE(HANDLE)

C  Restore original video mode and exit

      CALL FG_SETMODE(OLD_MODE)
      CALL FG_RESET

      STOP ' '
      END
