VERSION 4.00
Begin VB.Form Form1 
   BackColor       =   &H00FFFFFF&
   Caption         =   "Image File Demo"
   ClientHeight    =   4140
   ClientLeft      =   1140
   ClientTop       =   1800
   ClientWidth     =   6690
   Height          =   4830
   Left            =   1080
   LinkTopic       =   "Form1"
   ScaleHeight     =   4140
   ScaleWidth      =   6690
   Top             =   1170
   Width           =   6810
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   600
      Top             =   480
      _Version        =   65536
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
   End
   Begin VB.Menu mnuBmp 
      Caption         =   "&BMP"
      Begin VB.Menu mnuBmpItem 
         Caption         =   "&Open"
         Index           =   0
      End
      Begin VB.Menu mnuBmpItem 
         Caption         =   "&Make"
         Enabled         =   0   'False
         Index           =   1
      End
      Begin VB.Menu mnuBmpItem 
         Caption         =   "&Info"
         Enabled         =   0   'False
         Index           =   2
      End
   End
   Begin VB.Menu mnuPcx 
      Caption         =   "&PCX"
      Begin VB.Menu mnuPcxItem 
         Caption         =   "&Open"
         Index           =   0
      End
      Begin VB.Menu mnuPcxItem 
         Caption         =   "&Make"
         Enabled         =   0   'False
         Index           =   1
      End
      Begin VB.Menu mnuPcxItem 
         Caption         =   "&Info"
         Enabled         =   0   'False
         Index           =   2
      End
   End
   Begin VB.Menu mnuFliFlc 
      Caption         =   "&FLI/FLC"
      Begin VB.Menu mnuFliFlcItem 
         Caption         =   "&Open"
         Index           =   0
      End
      Begin VB.Menu mnuFliFlcItem 
         Caption         =   "&Play"
         Enabled         =   0   'False
         Index           =   1
      End
      Begin VB.Menu mnuFliFlcItem 
         Caption         =   "&Frame"
         Enabled         =   0   'False
         Index           =   2
      End
      Begin VB.Menu mnuFliFlcItem 
         Caption         =   "&Reset"
         Enabled         =   0   'False
         Index           =   3
      End
      Begin VB.Menu mnuFliFlcItem 
         Caption         =   "&Info"
         Enabled         =   0   'False
         Index           =   4
      End
   End
   Begin VB.Menu mnuQuit 
      Caption         =   "&Quit"
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False

'*****************************************************************************
'                                                                            *
'  IMAGE.FRM                                                                 *
'                                                                            *
'  This program demonstrates the Fastgraph for Windows image file display    *
'  and creation functions.                                                   *
'                                                                            *
'*****************************************************************************

Dim Context(16) As Byte
Dim FileHeader(128) As Byte
Dim FilePalette(768) As Byte
Dim FileName As String

Dim hPal As Long
Dim hvb As Long
Dim cxClient As Long, cyClient As Long
Dim cxBuffer As Long, cyBuffer As Long

Dim Colors As Long
Dim Frames As Integer

Private Sub Form_Activate()
   Call fg_realize(hPal)
   Refresh
End Sub

Private Sub Form_Load()
   ScaleMode = 3
   Call fg_setdc(hDC)
   hPal = fg_defpal()
   Call fg_realize(hPal)

   Call fg_vbinit
   hvb = fg_vballoc(1, 1)
   Call fg_vbopen(hvb)
   Call fg_vbcolors

   Call fg_setcolor(25)
   Call fg_fillpage
End Sub

Private Sub Form_Paint()
   Call fg_vbscale(0, fg_getmaxx(), 0, fg_getmaxy(), 0, cxClient - 1, 0, cyClient - 1)
End Sub

Private Sub Form_Resize()
   cxClient = ScaleWidth
   cyClient = ScaleHeight
   Refresh
End Sub

Private Sub Form_Unload(Cancel As Integer)
   Call fg_vbclose
   Call fg_vbfree(hvb)
   Call fg_vbfin
End Sub

'*****************************************************************************
'                                                                            *
'  Display or create a BMP file.                                             *
'                                                                            *
'*****************************************************************************

Private Sub mnuBmpItem_Click(Index As Integer)
   On Error GoTo ErrHandler

   Select Case Index
      Case 0   ' Open
         CommonDialog1.FileName = ""
         CommonDialog1.Filter = "BMP files (*.BMP)|*.BMP"
         CommonDialog1.ShowOpen
         If fg_bmphead(CommonDialog1.FileName, FileHeader(1)) < 0 Then
            Call MsgBox(CommonDialog1.FileName + " is not a BMP file.", vbCritical, "BMP")
            Exit Sub
         End If
         FileName = CommonDialog1.FileName
         Call fg_bmpsize(FileHeader(1), cxBuffer, cyBuffer)
         Call SwitchBuffers
         Call fg_showbmp(FileName, 0)
         Call fg_vbscale(0, cxBuffer - 1, 0, cyBuffer - 1, 0, cxClient - 1, 0, cyClient - 1)
         Colors = fg_bmppal(FileName, FilePalette(1))
         mnuBmpItem(1).Enabled = True
         mnuBmpItem(2).Enabled = True
         mnuPcxItem(1).Enabled = True
         mnuPcxItem(2).Enabled = False
         mnuFliFlcItem(1).Enabled = False
         mnuFliFlcItem(2).Enabled = False
         mnuFliFlcItem(3).Enabled = False
         mnuFliFlcItem(4).Enabled = False

      Case 1   ' Make
         CommonDialog1.DefaultExt = ".bmp"
         CommonDialog1.FileName = Left(FileName, InStr(FileName, ".") - 1)
         CommonDialog1.Filter = "BMP files (*.BMP)|*.BMP"
         CommonDialog1.ShowSave
         Call fg_makebmp(0, cxBuffer - 1, 0, cyBuffer - 1, Colors, CommonDialog1.FileName)

      Case 2   ' Info
         Call MsgBox(FileName + vbCr + _
                     Str(cxBuffer) + " x" + Str(cyBuffer) + " pixels" + vbCr + _
                     Str(Colors) + " colors", vbInformation, "BMP")
   End Select
   Exit Sub

ErrHandler:  ' user pressed Cancel button
   Exit Sub
End Sub

'*****************************************************************************
'                                                                            *
'  Play a flic file one frame at a time, or continuously.                    *
'                                                                            *
'*****************************************************************************

Private Sub mnuFliFlcItem_Click(Index As Integer)
   On Error GoTo ErrHandler

   Select Case Index
      Case 0   ' Open
         CommonDialog1.FileName = ""
         CommonDialog1.Filter = "flic files (*.FLI,*.FLC)|*.FLI;*.FLC"
         CommonDialog1.ShowOpen
         If fg_flichead(CommonDialog1.FileName, FileHeader(1)) < 0 Then
            Call MsgBox(CommonDialog1.FileName + " is not an FLI or FLC file.", vbCritical, "flic")
            Exit Sub
         End If
         FileName = CommonDialog1.FileName
         Call fg_flicsize(FileHeader(1), cxBuffer, cyBuffer)
         Call SwitchBuffers
         Call fg_flicopen(FileName, Context(1))
         Call fg_flicplay(Context(1), 1, 0)
         Call fg_vbscale(0, cxBuffer - 1, 0, cyBuffer - 1, 0, cxClient - 1, 0, cyClient - 1)
         Colors = 256
         Frames = FileHeader(8) * 256 + FileHeader(7)
         mnuFliFlcItem(1).Enabled = True
         mnuFliFlcItem(2).Enabled = True
         mnuFliFlcItem(3).Enabled = True
         mnuFliFlcItem(4).Enabled = True
         mnuBmpItem(1).Enabled = True
         mnuBmpItem(2).Enabled = False
         mnuPcxItem(1).Enabled = True
         mnuPcxItem(2).Enabled = False

      Case 1   ' Play
         Call fg_showflic(FileName, 0, 1)
         Call fg_flicskip(Context(1), -1)

      Case 2   ' Frame
         If fg_flicplay(Context(1), 1, 0) = 0 Then
            Call fg_flicskip(Context(1), -1)
            Call fg_flicplay(Context(1), 1, 0)
         End If
         Call fg_vbscale(0, cxBuffer - 1, 0, cyBuffer - 1, 0, cxClient - 1, 0, cyClient - 1)

      Case 3   ' Reset
         Call fg_flicskip(Context(1), -1)
         Call fg_flicplay(Context(1), 1, 0)
         Call fg_vbscale(0, cxBuffer - 1, 0, cyBuffer - 1, 0, cxClient - 1, 0, cyClient - 1)

      Case 4   ' Info
         Call MsgBox(FileName + vbCr + _
                     Str(cxBuffer) + " x" + Str(cyBuffer) + " pixels" + vbCr + _
                     Str(Frames) + " frames", vbInformation, "FLI/FLC")
   End Select
   Exit Sub

ErrHandler:  ' user pressed Cancel button
   Exit Sub
End Sub

'*****************************************************************************
'                                                                            *
'  Display or create a PCX file.                                             *
'                                                                            *
'*****************************************************************************

Private Sub mnuPcxItem_Click(Index As Integer)
   Dim MinX As Long, MaxX As Long, MinY As Long, MaxY As Long
   On Error GoTo ErrHandler

   Select Case Index
      Case 0   ' Open
         CommonDialog1.FileName = ""
         CommonDialog1.Filter = "PCX files (*.PCX)|*.PCX"
         CommonDialog1.ShowOpen
         If fg_pcxhead(CommonDialog1.FileName, FileHeader(1)) < 0 Then
            Call MsgBox(CommonDialog1.FileName + " is not a PCX file.", vbCritical, "PCX")
            Exit Sub
         End If
         FileName = CommonDialog1.FileName
         Call fg_pcxrange(FileHeader(1), MinX, MaxX, MinY, MaxY)
         cxBuffer = MaxX - MinX + 1
         cyBuffer = MaxY - MinY + 1
         Call SwitchBuffers
         Call fg_move(0, 0)
         Call fg_showpcx(FileName, 2)
         Call fg_vbscale(0, cxBuffer - 1, 0, cyBuffer - 1, 0, cxClient - 1, 0, cyClient - 1)
         Colors = fg_pcxpal(FileName, FilePalette(1))
         mnuPcxItem(1).Enabled = True
         mnuPcxItem(2).Enabled = True
         mnuBmpItem(1).Enabled = True
         mnuBmpItem(2).Enabled = False
         mnuFliFlcItem(1).Enabled = False
         mnuFliFlcItem(2).Enabled = False
         mnuFliFlcItem(3).Enabled = False
         mnuFliFlcItem(4).Enabled = False

      Case 1   ' Make
         CommonDialog1.DefaultExt = ".pcx"
         CommonDialog1.FileName = Left(FileName, InStr(FileName, ".") - 1)
         CommonDialog1.Filter = "PCX files (*.PCX)|*.PCX"
         CommonDialog1.ShowSave
         Call fg_makepcx(0, cxBuffer - 1, 0, cyBuffer - 1, CommonDialog1.FileName)

      Case 2   ' Info
         Call MsgBox(FileName + vbCr + _
                     Str(cxBuffer) + " x" + Str(cyBuffer) + " pixels" + vbCr + _
                     Str(Colors) + " colors", vbInformation, "PCX")
   End Select
   Exit Sub

ErrHandler:  ' user pressed Cancel button
   Exit Sub
End Sub

Private Sub mnuQuit_Click()
   Unload Me
End Sub

'*****************************************************************************
'                                                                            *
'  SwitchBuffers                                                             *
'                                                                            *
'  Close the and release the active virtual buffer, then create and open a   *
'  new virtual buffer to hold the new image file.                            *
'                                                                            *
'*****************************************************************************

Private Sub SwitchBuffers()
   Call fg_vbclose
   Call fg_vbfree(hvb)
   hvb = fg_vballoc(cxBuffer, cyBuffer)
   Call fg_vbopen(hvb)
   Call fg_vbcolors
End Sub

