{*****************************************************************************
*                                                                            *
*  IMAGE.PAS                                                                 *
*                                                                            *
*  This program demonstrates the Fastgraph for Windows image file display    *
*  and creation functions.                                                   *
*                                                                            *
*****************************************************************************}

program image;

{$IFDEF VER80}
uses WinTypes, WinProcs, Messages, CommDlg, SysUtils, FGWinG;
{$ELSE}
uses WinTypes, WinProcs, CommDlg, Strings, FGWinG;
{$ENDIF}

const
  AppName = 'FGimage';

  IDM_BMPOPEN   = 101;
  IDM_BMPMAKE   = 102;
  IDM_BMPINFO   = 103;

  IDM_PCXOPEN   = 201;
  IDM_PCXMAKE   = 202;
  IDM_PCXINFO   = 203;

  IDM_FLICOPEN  = 301;
  IDM_FLICPLAY  = 302;
  IDM_FLICFRAME = 303;
  IDM_FLICRESET = 304;
  IDM_FLICINFO  = 305;

  IDM_QUIT    =   4;

var
  cxClient, cyClient : word;
  cxBuffer, cyBuffer : integer;
  colors : integer;
  dc   : hDC;
  menu : hMenu;
  hpal : hPalette;
  hvb  : integer;

  default_file : array [0..255] of char;
  file_header  : array [0..127] of byte;
  file_palette : array [1..768] of byte;
  file_title   : array [0..15] of char;
  file_name    : string;
  open_file    : string;
  mb_text      : string;
  mb_ptr       : pChar;

  context : array [1..16] of byte;
  frames  : integer;

{*****************************************************************************
*                                                                            *
*  get_open_filename                                                         *
*                                                                            *
*  Display a dialog box that selects a list of file names that match the     *
*  specified file name. This function uses the Open File dialog box from the *
*  Windows common dialog box library.                                        *
*                                                                            *
*  The selected file name is stored with full path information in the global *
*  variable file_name, and without path information in file_title.           *
*                                                                            *
*****************************************************************************}

function get_open_filename(matchtype, matchfile : string) : boolean;

var
  filter : array [0..127] of char;
  default_extension : array [0..2] of char;
  fn : tOpenFilename;
  i : integer;

begin

  { construct file name filter string }
  StrPCopy(filter,matchtype);
  i := StrLen(filter) + 1;
  StrPCopy(@filter[i],matchfile);
  i := i + StrLen(@filter[i]) + 1;
  filter[i] := chr(0);
  default_file[0] := chr(0);
  StrPCopy(default_extension,matchfile[2]);

  { fill in structure fields for Open File dialog box }
  fn.lStructSize       := SizeOf(tOpenFilename);
  fn.hwndOwner         := GetActiveWindow;
  fn.lpstrFilter       := filter;
  fn.lpstrCustomFilter := nil;
  fn.nFilterIndex      := 1;
  fn.lpstrFile         := default_file;
  fn.nMaxFile          := 256;
  fn.lpstrFileTitle    := file_title;
  fn.nMaxFileTitle     := 16;
  fn.lpstrInitialDir   := nil;
  fn.lpstrTitle        := nil;
  fn.Flags             := 0;
  fn.lpstrDefExt       := default_extension;

  { activate the Open File dialog box }
  if GetOpenFileName(fn) then
  begin
    file_name := StrPas(default_file) + chr(0);
    open_file := StrPas(file_title);
    get_open_filename := TRUE;
  end
  else
    get_open_filename := FALSE;
end;

{*****************************************************************************
*                                                                            *
*  get_save_filename                                                         *
*                                                                            *
*  Display a dialog box that selects a list of file names that match the     *
*  specified file name. This function uses the Open File dialog box from the *
*  Windows common dialog box library.                                        *
*                                                                            *
*  The selected file name is stored with full path information in the global *
*  variable file_name, and without path information in file_title.           *
*                                                                            *
*****************************************************************************}

function get_save_filename(extension : string) : boolean;

var
  default_extension : array [0..2] of char;
  fn : tOpenFilename;
  i : integer;

begin

  { construct default file name for the dialog box edit control }
  StrCopy(default_file,file_title);
  for i := 0 to StrLen(file_title)-1 do
  begin
    if (default_file[i] = '.') then default_file[i] := chr(0);
  end;
  StrPCopy(default_extension,extension);

  { fill in structure fields for Open File dialog box }
  fn.lStructSize       := SizeOf(tOpenFilename);
  fn.hwndOwner         := GetActiveWindow;
  fn.lpstrFilter       := nil;
  fn.lpstrCustomFilter := nil;
  fn.lpstrFile         := default_file;
  fn.nMaxFile          := 256;
  fn.lpstrFileTitle    := file_title;
  fn.nMaxFileTitle     := 16;
  fn.lpstrInitialDir   := nil;
  fn.lpstrTitle        := nil;
  fn.Flags             := OFN_OVERWRITEPROMPT OR OFN_PATHMUSTEXIST;
  fn.lpstrDefExt       := default_extension;

  { activate the Open File dialog box }
  if GetSaveFileName(fn) then
  begin
    file_name := StrPas(default_file) + chr(0);
    get_save_filename := TRUE;
  end
  else
    get_save_filename := FALSE;
end;

{*****************************************************************************
*                                                                            *
*  switch_buffers                                                            *
*                                                                            *
*  Close the and release the active virtual buffer, then create and open a   *
*  new virtual buffer to hold the new image file.                            *
*                                                                            *
*****************************************************************************}

procedure switch_buffers;
begin
  fg_vbclose;
  fg_vbfree(hvb);
  hvb := fg_vballoc(cxBuffer,cyBuffer);
  fg_vbopen(hvb);
  fg_vbcolors;
end;

{*****************************************************************************
*                                                                            *
*  do_bmp                                                                    *
*                                                                            *
*  Display or create a BMP file.                                             *
*                                                                            *
*****************************************************************************}

procedure do_bmp(selection : word);

var
  s : string;

begin
  case selection of
    IDM_BMPOPEN:
    begin
      if (get_open_filename('BMP files (*.BMP)','*.BMP') = FALSE) then
        Exit;
      if (fg_bmphead(file_name,file_header) < 0) then
      begin
        mb_text := file_title + ' is not a BMP file.' + chr(0);
        mb_ptr  := @mb_text[1];
        MessageBox(GetActiveWindow,mb_ptr,'BMP',MB_ICONSTOP OR MB_OK);
        Exit;
      end;
      fg_bmpsize(file_header,cxBuffer,cyBuffer);
      switch_buffers;
      fg_showbmp(file_name,0);
      fg_vbscale(0,cxBuffer-1,0,cyBuffer-1,0,cxClient-1,0,cyClient-1);
      colors := fg_bmppal(file_name,file_palette);

      EnableMenuItem(menu,IDM_BMPMAKE,MF_ENABLED);
      EnableMenuItem(menu,IDM_BMPINFO,MF_ENABLED);
      EnableMenuItem(menu,IDM_PCXMAKE,MF_ENABLED);
      EnableMenuItem(menu,IDM_PCXINFO,MF_GRAYED);
      EnableMenuItem(menu,IDM_FLICPLAY,MF_GRAYED);
      EnableMenuItem(menu,IDM_FLICFRAME,MF_GRAYED);
      EnableMenuItem(menu,IDM_FLICRESET,MF_GRAYED);
      EnableMenuItem(menu,IDM_FLICINFO,MF_GRAYED);

      Exit;
    end;

    IDM_BMPMAKE:
    begin
      if (get_save_filename('BMP')) then
        fg_makebmp(0,cxBuffer-1,0,cyBuffer-1,colors,file_name);
      Exit;
    end;

    IDM_BMPINFO:
    begin
      Str(cxBuffer,s);
      mb_text := open_file + chr(13) + s + 'x';
      Str(cyBuffer,s);
      mb_text := mb_text + s + ' pixels' + chr(13);
      Str(colors,s);
      mb_text := mb_text + s + ' colors' + chr(0);
      mb_ptr  := @mb_text[1];
      MessageBox(GetActiveWindow,mb_ptr,'BMP',MB_ICONINFORMATION OR MB_OK);
      Exit;
    end;
  end;
end;

{*****************************************************************************
*                                                                            *
*  do_flic                                                                   *
*                                                                            *
*  Play a flic file one frame at a time, or continuously.                    *
*                                                                            *
*****************************************************************************}

procedure do_flic(selection : word);

var
  s : string;
  
begin
  case selection of
    IDM_FLICOPEN:
    begin
      if (get_open_filename('flic files (*.FLI,*.FLC)','*.FLI;*.FLC') = FALSE) then
        Exit;
      if (fg_flichead(file_name,file_header) < 0) then
      begin
        mb_text := file_title + ' is not an FLI or FLC file.' + chr(0);
        mb_ptr  := @mb_text[1];
        MessageBox(GetActiveWindow,mb_ptr,'flic',MB_ICONSTOP OR MB_OK);
        Exit;
      end;
      fg_flicsize(file_header,cxBuffer,cyBuffer);
      switch_buffers;
      fg_flicopen(file_name,context);
      fg_flicplay(context,1,0);
      fg_vbscale(0,cxBuffer-1,0,cyBuffer-1,0,cxClient-1,0,cyClient-1);
      colors := 256;
      Move(file_header[6],frames,2);

      EnableMenuItem(menu,IDM_FLICPLAY,MF_ENABLED);
      EnableMenuItem(menu,IDM_FLICFRAME,MF_ENABLED);
      EnableMenuItem(menu,IDM_FLICRESET,MF_ENABLED);
      EnableMenuItem(menu,IDM_FLICINFO,MF_ENABLED);
      EnableMenuItem(menu,IDM_BMPMAKE,MF_ENABLED);
      EnableMenuItem(menu,IDM_BMPINFO,MF_GRAYED);
      EnableMenuItem(menu,IDM_PCXMAKE,MF_ENABLED);
      EnableMenuItem(menu,IDM_PCXINFO,MF_GRAYED);

      Exit;
    end;

    IDM_FLICPLAY:
    begin
      fg_showflic(file_name,0,1);
      fg_flicskip(context,-1);
      Exit;
    end;

    IDM_FLICFRAME:
    begin
      if (fg_flicplay(context,1,0) = 0) then
      begin
        fg_flicskip(context,-1);
        fg_flicplay(context,1,0);
      end;
      fg_vbscale(0,cxBuffer-1,0,cyBuffer-1,0,cxClient-1,0,cyClient-1);
      Exit;
    end;

    IDM_FLICRESET:
    begin
      fg_flicskip(context,-1);
      fg_flicplay(context,1,0);
      fg_vbscale(0,cxBuffer-1,0,cyBuffer-1,0,cxClient-1,0,cyClient-1);
      Exit;
    end;

    IDM_FLICINFO:
    begin
      Str(cxBuffer,s);
      mb_text := open_file + chr(13) + s + 'x';
      Str(cyBuffer,s);
      mb_text := mb_text + s + ' pixels' + chr(13);
      Str(frames,s);
      mb_text := mb_text + s + ' frames' + chr(0);
      mb_ptr  := @mb_text[1];
      MessageBox(GetActiveWindow,mb_ptr,'FLI/FLC',MB_ICONINFORMATION OR MB_OK);
      Exit;
    end;
  end;
end;

{*****************************************************************************
*                                                                            *
*  do_pcx                                                                    *
*                                                                            *
*  Display or create a PCX file.                                             *
*                                                                            *
*****************************************************************************}

procedure do_pcx(selection : word);

var
  s : string;
  minx, maxx, miny, maxy : integer;
  
begin
  case selection of
    IDM_PCXOPEN:
    begin
      if (get_open_filename('PCX files (*.PCX)','*.PCX') = FALSE) then
        Exit;
      if (fg_pcxhead(file_name,file_header) < 0) then
      begin
        mb_text := file_title + ' is not a PCX file.' + chr(0);
        mb_ptr  := @mb_text[1];
        MessageBox(GetActiveWindow,mb_ptr,'PCX',MB_ICONSTOP OR MB_OK);
        Exit;
      end;
      fg_pcxrange(file_header,minx,maxx,miny,maxy);
      cxBuffer := maxx - minx + 1;
      cyBuffer := maxy - miny + 1;
      switch_buffers;
      fg_move(0,0);
      fg_showpcx(file_name,2);
      fg_vbscale(0,cxBuffer-1,0,cyBuffer-1,0,cxClient-1,0,cyClient-1);
      colors := fg_pcxpal(file_name,file_palette);

      EnableMenuItem(menu,IDM_PCXMAKE,MF_ENABLED);
      EnableMenuItem(menu,IDM_PCXINFO,MF_ENABLED);
      EnableMenuItem(menu,IDM_BMPMAKE,MF_ENABLED);
      EnableMenuItem(menu,IDM_BMPINFO,MF_GRAYED);
      EnableMenuItem(menu,IDM_FLICPLAY,MF_GRAYED);
      EnableMenuItem(menu,IDM_FLICFRAME,MF_GRAYED);
      EnableMenuItem(menu,IDM_FLICRESET,MF_GRAYED);
      EnableMenuItem(menu,IDM_FLICINFO,MF_GRAYED);

      Exit;
    end;

    IDM_PCXMAKE:
    begin
      if (get_save_filename('PCX')) then
        fg_makepcx(0,cxBuffer-1,0,cyBuffer-1,file_name);
      Exit;
    end;

    IDM_PCXINFO:
    begin
      Str(cxBuffer,s);
      mb_text := open_file + chr(13) + s + 'x';
      Str(cyBuffer,s);
      mb_text := mb_text + s + ' pixels' + chr(13);
      Str(colors,s);
      mb_text := mb_text + s + ' colors' + chr(0);
      mb_ptr  := @mb_text[1];
      MessageBox(GetActiveWindow,mb_ptr,'PCX',MB_ICONINFORMATION OR MB_OK);
      Exit;
    end;
  end;
end;

{*****************************************************************************
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
*****************************************************************************}

function WindowProc(window : hwnd; message : word;
                    wParam : word; lParam : longint): longint; export;
var
  ps : tPaintStruct;

begin

  WindowProc := 0;

  case message of

    WM_CREATE:
    begin
      dc := GetDC(window);
      fg_setdc(dc);
      hpal := fg_defpal;
      fg_realize(hpal);

      fg_vbinit;
      hvb := fg_vballoc(1,1);
      fg_vbopen(hvb);
      fg_vbcolors;

      fg_setcolor(25);
      fg_fillpage;
      menu := GetMenu(window);
      Exit;
    end;

    WM_COMMAND:
    begin
      case wParam of
        IDM_BMPOPEN, IDM_BMPMAKE, IDM_BMPINFO:
        begin
          do_bmp(wParam);
          Exit;
        end;

        IDM_PCXOPEN, IDM_PCXMAKE, IDM_PCXINFO:
        begin
          do_pcx(wParam);
          Exit;
        end;

        IDM_FLICOPEN, IDM_FLICPLAY, IDM_FLICFRAME, IDM_FLICRESET, IDM_FLICINFO:
        begin
          do_flic(wParam);
          Exit;
        end;

        IDM_QUIT:
        begin
          SendMessage(window,WM_CLOSE,0,0);
          Exit;
        end;
      end;
    end;

    WM_PAINT:
    begin
      BeginPaint(window,ps);
      fg_vbscale(0,fg_getmaxx,0,fg_getmaxy,0,cxClient-1,0,cyClient-1);
      EndPaint(window,ps);
      Exit;
    end;

    WM_SETFOCUS:
    begin
      fg_realize(hpal);
      InvalidateRect(window,nil,TRUE);
      Exit;
    end;

    WM_SIZE:
    begin
      cxClient := LOWORD(lParam);
      cyClient := HIWORD(lParam);
      Exit;
    end;

    WM_DESTROY:
    begin
      fg_vbclose;
      fg_vbfree(hvb);
      fg_vbfin;
      DeleteObject(hpal);
      ReleaseDC(window,dc);
      PostQuitMessage(0);
      Exit;
    end;

  end;
  WindowProc := DefWindowProc(window,message,wParam,lParam);
end;

{****************************************************************************}

procedure WinMain;

var
  window      : hWnd;
  message     : tMsg;
  WindowClass : tWndClass;

begin
  if hPrevInst = 0 then
  begin
    WindowClass.style         := CS_HREDRAW OR CS_VREDRAW;
    WindowClass.lpfnWndProc   := @WindowProc;
    WindowClass.cbClsExtra    := 0;
    WindowClass.cbWndExtra    := 0;
    WindowClass.hInstance     := hInstance;
    WindowClass.hIcon         := LoadIcon(0,IDI_APPLICATION);
    WindowClass.hCursor       := LoadCursor(0,IDC_ARROW);
    WindowClass.hbrBackground := GetStockObject(WHITE_BRUSH);
    WindowClass.lpszMenuName  := AppName;
    WindowClass.lpszClassName := AppName;
    if not RegisterClass(WindowClass) then Halt(255);
  end;

  window := CreateWindow(
    AppName,                    { window class name }
    'Image File Demo',          { window caption }
    WS_OVERLAPPEDWINDOW,        { window style }
    CW_USEDEFAULT,              { initial x position }
    CW_USEDEFAULT,              { initial y position }
    CW_USEDEFAULT,              { initial x size }
    CW_USEDEFAULT,              { initial y size }
    0,                          { parent window handle }
    0,                          { window menu handle }
    hInstance,                  { program instance handle }
    nil);                       { creation parameters }

  ShowWindow(window,CmdShow);
  UpdateWindow(window);

  while GetMessage(message,0,0,0) do
  begin
    TranslateMessage(message);
    DispatchMessage(message);
  end;

  Halt(message.wParam);
end;

begin
  WinMain;
end.
