{*****************************************************************************
*                                                                            *
*  IMAGE.DPR                                                                 *
*  IMAGEU.PAS                                                                *
*                                                                            *
*  This program demonstrates the Fastgraph for Windows image file display    *
*  and creation functions.                                                   *
*                                                                            *
*****************************************************************************}

unit imageU;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FGWin, CommDlg, Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    BMP1: TMenuItem;
     Open1: TMenuItem;
     Make1: TMenuItem;
     Info1: TMenuItem;
    PCX1: TMenuItem;
     Open2: TMenuItem;
     Make2: TMenuItem;
     Info2: TMenuItem;
    FLIFLC1: TMenuItem;
     Open3: TMenuItem;
     Play3: TMenuItem;
     Frame3: TMenuItem;
     Reset3: TMenuItem;
     Info3: TMenuItem;
    Quit1: TMenuItem;
    procedure AppOnActivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BMPopen(Sender: TObject);
    procedure BMPmake(Sender: TObject);
    procedure BMPinfo(Sender: TObject);
    procedure PCXopen(Sender: TObject);
    procedure PCXmake(Sender: TObject);
    procedure PCXinfo(Sender: TObject);
    procedure FLICopen(Sender: TObject);
    procedure FLICplay(Sender: TObject);
    procedure FLICframe(Sender: TObject);
    procedure FLICreset(Sender: TObject);
    procedure FLICinfo(Sender: TObject);
    procedure Quit(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
var
  cxClient, cyClient : integer;
  cxBuffer, cyBuffer : integer;
  colors : integer;
  dc     : hDC;
  hpal   : hPalette;
  hvb    : integer;

  default_file : array [0..255] of char;
  file_header  : array [0..127] of byte;
  file_palette : array [1..768] of byte;
  file_title   : array [0..15] of char;
  file_name    : string;
  open_file    : string;
  mb_text      : string;
  mb_ptr       : pChar;

  context : array [1..16] of byte;
  frames  : integer;

{*****************************************************************************
*                                                                            *
*  get_open_filename                                                         *
*                                                                            *
*  Display a dialog box that selects a list of file names that match the     *
*  specified file name. This function uses the Open File dialog box from the *
*  Windows common dialog box library.                                        *
*                                                                            *
*  The selected file name is stored with full path information in the global *
*  variable file_name, and without path information in file_title.           *
*                                                                            *
*****************************************************************************}

function get_open_filename(matchtype, matchfile : string) : boolean;

var
  filter : array [0..127] of char;
  default_extension : array [0..2] of char;
  fn : tOpenFilename;
  i : integer;

begin

  { construct file name filter string }
  StrPCopy(filter,matchtype);
  i := StrLen(filter) + 1;
  StrPCopy(@filter[i],matchfile);
  i := i + StrLen(@filter[i]) + 1;
  filter[i] := chr(0);
  default_file[0] := chr(0);
  StrPCopy(default_extension,matchfile[2]);

  { fill in structure fields for Open File dialog box }
  fn.lStructSize       := SizeOf(tOpenFilename);
  fn.hwndOwner         := GetActiveWindow;
  fn.lpstrFilter       := filter;
  fn.lpstrCustomFilter := nil;
  fn.nFilterIndex      := 1;
  fn.lpstrFile         := default_file;
  fn.nMaxFile          := 256;
  fn.lpstrFileTitle    := file_title;
  fn.nMaxFileTitle     := 16;
  fn.lpstrInitialDir   := nil;
  fn.lpstrTitle        := nil;
  fn.Flags             := 0;
  fn.lpstrDefExt       := default_extension;

  { activate the Open File dialog box }
  if GetOpenFileName(fn) then
  begin
    file_name := StrPas(default_file) + chr(0);
    open_file := StrPas(file_title);
    get_open_filename := TRUE;
  end
  else
    get_open_filename := FALSE;
end;

{*****************************************************************************
*                                                                            *
*  get_save_filename                                                         *
*                                                                            *
*  Display a dialog box that selects a list of file names that match the     *
*  specified file name. This function uses the Open File dialog box from the *
*  Windows common dialog box library.                                        *
*                                                                            *
*  The selected file name is stored with full path information in the global *
*  variable file_name, and without path information in file_title.           *
*                                                                            *
*****************************************************************************}

function get_save_filename(extension : string) : boolean;

var
  default_extension : array [0..2] of char;
  fn : tOpenFilename;
  i : integer;

begin

  { construct default file name for the dialog box edit control }
  StrCopy(default_file,file_title);
  for i := 0 to StrLen(file_title)-1 do
  begin
    if (default_file[i] = '.') then default_file[i] := chr(0);
  end;
  StrPCopy(default_extension,extension);

  { fill in structure fields for Open File dialog box }
  fn.lStructSize       := SizeOf(tOpenFilename);
  fn.hwndOwner         := GetActiveWindow;
  fn.lpstrFilter       := nil;
  fn.lpstrCustomFilter := nil;
  fn.lpstrFile         := default_file;
  fn.nMaxFile          := 256;
  fn.lpstrFileTitle    := file_title;
  fn.nMaxFileTitle     := 16;
  fn.lpstrInitialDir   := nil;
  fn.lpstrTitle        := nil;
  fn.Flags             := OFN_OVERWRITEPROMPT OR OFN_PATHMUSTEXIST;
  fn.lpstrDefExt       := default_extension;

  { activate the Open File dialog box }
  if GetSaveFileName(fn) then
  begin
    file_name := StrPas(default_file) + chr(0);
    get_save_filename := TRUE;
  end
  else
    get_save_filename := FALSE;
end;

{*****************************************************************************
*                                                                            *
*  switch_buffers                                                            *
*                                                                            *
*  Close the and release the active virtual buffer, then create and open a   *
*  new virtual buffer to hold the new image file.                            *
*                                                                            *
*****************************************************************************}

procedure switch_buffers;
begin
  fg_vbclose;
  fg_vbfree(hvb);
  hvb := fg_vballoc(cxBuffer,cyBuffer);
  fg_vbopen(hvb);
  fg_vbcolors;
end;

{****************************************************************************}

procedure TForm1.AppOnActivate(Sender: TObject);
begin
  fg_realize(hpal);
  Invalidate;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  fg_realize(hpal);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  dc := GetDC(Form1.Handle);
  fg_setdc(dc);
  hpal := fg_defpal;
  fg_realize(hpal);

  fg_vbinit;
  hvb := fg_vballoc(1,1);
  fg_vbopen(hvb);
  fg_vbcolors;

  fg_setcolor(25);
  fg_fillpage;

  Application.OnActivate := AppOnActivate;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  fg_vbscale(0,fg_getmaxx,0,fg_getmaxy,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  cxClient := ClientWidth;
  cyClient := ClientHeight;
  Invalidate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fg_vbclose;
  fg_vbfree(hvb);
  fg_vbfin;
  DeleteObject(hpal);
  ReleaseDC(Form1.Handle,dc);
end;

{*****************************************************************************
*                                                                            *
*  Event handlers for the selections on the BMP menu                         *
*                                                                            *
*****************************************************************************}

procedure TForm1.BMPopen(Sender: TObject);
begin
  if (get_open_filename('BMP files (*.BMP)','*.BMP') = FALSE) then
    Exit;
  if (fg_bmphead(file_name,file_header) < 0) then
  begin
    mb_text := file_title + ' is not a BMP file.' + chr(0);
    mb_ptr  := @mb_text[1];
    Application.MessageBox(mb_ptr,'BMP',MB_ICONSTOP OR MB_OK);
    Exit;
  end;
  fg_bmpsize(file_header,cxBuffer,cyBuffer);
  switch_buffers;
  fg_showbmp(file_name,0);
  fg_vbscale(0,cxBuffer-1,0,cyBuffer-1,0,cxClient-1,0,cyClient-1);
  colors := fg_bmppal(file_name,file_palette);

  Form1.Make1.Enabled  := True;
  Form1.Info1.Enabled  := True;
  Form1.Make2.Enabled  := True;
  Form1.Info2.Enabled  := False;
  Form1.Play3.Enabled  := False;
  Form1.Frame3.Enabled := False;
  Form1.Reset3.Enabled := False;
  Form1.Info3.Enabled  := False;
end;

procedure TForm1.BMPmake(Sender: TObject);
begin
  if (get_save_filename('BMP')) then
    fg_makebmp(0,cxBuffer-1,0,cyBuffer-1,colors,file_name);
end;

procedure TForm1.BMPinfo(Sender: TObject);
var
  s : string;
begin
  Str(cxBuffer,s);
  mb_text := open_file + chr(13) + s + 'x';
  Str(cyBuffer,s);
  mb_text := mb_text + s + ' pixels' + chr(13);
  Str(colors,s);
  mb_text := mb_text + s + ' colors' + chr(0);
  mb_ptr  := @mb_text[1];
  Application.MessageBox(mb_ptr,'BMP',MB_ICONINFORMATION OR MB_OK);
end;

{*****************************************************************************
*                                                                            *
*  Event handlers for the selections on the PCX menu                         *
*                                                                            *
*****************************************************************************}

procedure TForm1.PCXopen(Sender: TObject);
var
  minx, maxx, miny, maxy : integer;
begin
  if (get_open_filename('PCX files (*.PCX)','*.PCX') = FALSE) then
    Exit;
  if (fg_pcxhead(file_name,file_header) < 0) then
  begin
    mb_text := file_title + ' is not a PCX file.' + chr(0);
    mb_ptr  := @mb_text[1];
    Application.MessageBox(mb_ptr,'PCX',MB_ICONSTOP OR MB_OK);
    Exit;
  end;
  fg_pcxrange(file_header,minx,maxx,miny,maxy);
  cxBuffer := maxx - minx + 1;
  cyBuffer := maxy - miny + 1;
  switch_buffers;
  fg_move(0,0);
  fg_showpcx(file_name,2);
  fg_vbscale(0,cxBuffer-1,0,cyBuffer-1,0,cxClient-1,0,cyClient-1);
  colors := fg_pcxpal(file_name,file_palette);

  Form1.Make1.Enabled  := True;
  Form1.Info1.Enabled  := False;
  Form1.Make2.Enabled  := True;
  Form1.Info2.Enabled  := True;
  Form1.Play3.Enabled  := False;
  Form1.Frame3.Enabled := False;
  Form1.Reset3.Enabled := False;
  Form1.Info3.Enabled  := False;
end;

procedure TForm1.PCXmake(Sender: TObject);
begin
  if (get_save_filename('PCX')) then
    fg_makepcx(0,cxBuffer-1,0,cyBuffer-1,file_name);
end;

procedure TForm1.PCXinfo(Sender: TObject);
var
  s : string;
begin
  Str(cxBuffer,s);
  mb_text := open_file + chr(13) + s + 'x';
  Str(cyBuffer,s);
  mb_text := mb_text + s + ' pixels' + chr(13);
  Str(colors,s);
  mb_text := mb_text + s + ' colors' + chr(0);
  mb_ptr  := @mb_text[1];
  Application.MessageBox(mb_ptr,'PCX',MB_ICONINFORMATION OR MB_OK);
end;

{*****************************************************************************
*                                                                            *
*  Event handlers for the selections on the FLI/FLC menu                     *
*                                                                            *
*****************************************************************************}

procedure TForm1.FLICopen(Sender: TObject);
begin
  if (get_open_filename('flic files (*.FLI,*.FLC)','*.FLI;*.FLC') = FALSE) then
    Exit;
  if (fg_flichead(file_name,file_header) < 0) then
  begin
    mb_text := file_title + ' is not an FLI or FLC file.' + chr(0);
    mb_ptr  := @mb_text[1];
    Application.MessageBox(mb_ptr,'flic',MB_ICONSTOP OR MB_OK);
    Exit;
  end;
  fg_flicsize(file_header,cxBuffer,cyBuffer);
  switch_buffers;
  fg_flicopen(file_name,context);
  fg_flicplay(context,1,0);
  fg_vbscale(0,cxBuffer-1,0,cyBuffer-1,0,cxClient-1,0,cyClient-1);
  colors := 256;
  Move(file_header[6],frames,2);

  Form1.Make1.Enabled  := True;
  Form1.Info1.Enabled  := False;
  Form1.Make2.Enabled  := True;
  Form1.Info2.Enabled  := False;
  Form1.Play3.Enabled  := True;
  Form1.Frame3.Enabled := True;
  Form1.Reset3.Enabled := True;
  Form1.Info3.Enabled  := True;
end;

procedure TForm1.FLICplay(Sender: TObject);
begin
  fg_showflic(file_name,0,1);
  fg_flicskip(context,-1);
end;

procedure TForm1.FLICframe(Sender: TObject);
begin
  if (fg_flicplay(context,1,0) = 0) then
  begin
    fg_flicskip(context,-1);
    fg_flicplay(context,1,0);
  end;
  fg_vbscale(0,cxBuffer-1,0,cyBuffer-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.FLICreset(Sender: TObject);
begin
  fg_flicskip(context,-1);
  fg_flicplay(context,1,0);
  fg_vbscale(0,cxBuffer-1,0,cyBuffer-1,0,cxClient-1,0,cyClient-1);
end;

procedure TForm1.FLICinfo(Sender: TObject);
var
  s : string;
begin
  Str(cxBuffer,s);
  mb_text := open_file + chr(13) + s + 'x';
  Str(cyBuffer,s);
  mb_text := mb_text + s + ' pixels' + chr(13);
  Str(frames,s);
  mb_text := mb_text + s + ' frames' + chr(0);
  mb_ptr  := @mb_text[1];
  Application.MessageBox(mb_ptr,'FLI/FLC',MB_ICONINFORMATION OR MB_OK);
end;

{****************************************************************************}

procedure TForm1.Quit(Sender: TObject);
begin
  Halt(1);
end;

end.
