VERSION 4.00
Begin VB.Form Form1
   BackColor       =   &H00FFFFFF&
   Caption         =   "Color Cycling"
   ClientHeight    =   4140
   ClientLeft      =   1140
   ClientTop       =   1515
   ClientWidth     =   6690
   Height          =   4545
   Left            =   1080
   LinkTopic       =   "Form1"
   ScaleHeight     =   4140
   ScaleWidth      =   6690
   Top             =   1170
   Width           =   6810
   Begin VB.Timer Timer1
      Left            =   600
      Top             =   480
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False

'*****************************************************************************
'                                                                            *
'  RAINBOW.FRM                                                               *
'                                                                            *
'  This program demonstrates color palette cycling.                          *
'                                                                            *
'*****************************************************************************

Dim hPal As Long
Dim hvb As Long
Dim cxClient As Long, cyClient As Long

Dim RGBvalues(2 * 24 * 3) As Byte ' two sets of 24 RGB triplets
Dim Start As Long

Private Sub Form_Activate()
   fg_realize (hPal)
   Refresh
End Sub

Private Sub Form_Load()
   Dim Color As Integer
   Dim xLen As Integer, yLen As Integer

   ScaleMode = 3

   ' create the logical palettte
   Call fg_setdc(hDC)
   Call FillColorPalette
   hPal = fg_logpal(10, 24, RGBvalues(1))
   Call fg_realize(hPal)

   ' create a 640x480 virtual buffer
   Call fg_vbinit
   hvb = fg_vballoc(640, 480)
   Call fg_vbopen(hvb)
   Call fg_vbcolors

   ' construct a crude image of a rainbow
   Call fg_setcolor(255)
   Call fg_fillpage
   Call fg_setclip(0, 639, 0, 300)
   Call fg_move(320, 300)
   xLen = 240
   yLen = 120
   For Color = 10 To 33
      Call fg_setcolor(Color)
      Call fg_ellipsef(xLen, yLen)
      xLen = xLen - 4
      yLen = yLen - 3
   Next Color
   Call fg_setcolor(255)
   Call fg_ellipsef(xLen, yLen)
   Call fg_setclip(0, 639, 0, 479)

   ' starting index into the array of color values
   Start = 0
   Timer1.Interval = 50
End Sub

Private Sub Form_Paint()
   Call fg_vbscale(0, fg_getmaxx(), 0, fg_getmaxy(), 0, cxClient - 1, 0, cyClient - 1)
End Sub

Private Sub Form_Resize()
   cxClient = ScaleWidth
   cyClient = ScaleHeight
   Refresh
End Sub

Private Sub Form_Unload(Cancel As Integer)
   Call fg_vbclose
   Call fg_vbfree(hvb)
   Call fg_vbfin
End Sub

Private Sub Timer1_Timer()
   Start = (Start + 3) Mod 72
   Call fg_setdacs(10, 24, RGBvalues(Start + 1))
   If fg_colors > 8 Then
      Call fg_vbscale(0, fg_getmaxx(), 0, fg_getmaxy(), 0, cxClient - 1, 0, cyClient - 1)
   End If
End Sub

'*****************************************************************************
'                                                                            *
'  FillColorPalette                                                          *
'                                                                            *
'  Set up the colors for the application's logical palette in the RGBvalues  *
'  array. The logical palette will contain 24 non-system colors (indices 10  *
'  to 33) defining the initial RGB values for the colors being cycled.       *
'                                                                            *
'  Note that we store two identical sets of 24 RGB triplets in RGBvalues. We *
'  can then perform color cycling without having to worry about wrapping to  *
'  the start of the array because the index pointing to the starting RGB     *
'  triplet never extends beyond the first set of 24 RGB triplets.            *
'                                                                            *
'*****************************************************************************

Private Sub FillColorPalette()

   Dim I As Integer

   RGBvalues(1) = 182: RGBvalues(2) = 182: RGBvalues(3) = 255
   RGBvalues(4) = 198: RGBvalues(5) = 182: RGBvalues(6) = 255
   RGBvalues(7) = 218: RGBvalues(8) = 182: RGBvalues(9) = 255
   RGBvalues(10) = 234: RGBvalues(11) = 182: RGBvalues(12) = 255
   RGBvalues(13) = 255: RGBvalues(14) = 182: RGBvalues(15) = 255
   RGBvalues(16) = 255: RGBvalues(17) = 182: RGBvalues(18) = 234
   RGBvalues(19) = 255: RGBvalues(20) = 182: RGBvalues(21) = 218
   RGBvalues(22) = 255: RGBvalues(23) = 182: RGBvalues(24) = 198
   RGBvalues(25) = 255: RGBvalues(26) = 182: RGBvalues(27) = 182
   RGBvalues(28) = 255: RGBvalues(29) = 198: RGBvalues(30) = 182
   RGBvalues(31) = 255: RGBvalues(32) = 218: RGBvalues(33) = 182
   RGBvalues(34) = 255: RGBvalues(35) = 234: RGBvalues(36) = 182
   RGBvalues(37) = 255: RGBvalues(38) = 255: RGBvalues(39) = 182
   RGBvalues(40) = 234: RGBvalues(41) = 255: RGBvalues(42) = 182
   RGBvalues(43) = 218: RGBvalues(44) = 255: RGBvalues(45) = 182
   RGBvalues(46) = 198: RGBvalues(47) = 255: RGBvalues(48) = 182
   RGBvalues(49) = 182: RGBvalues(50) = 255: RGBvalues(51) = 182
   RGBvalues(52) = 182: RGBvalues(53) = 255: RGBvalues(54) = 198
   RGBvalues(55) = 182: RGBvalues(56) = 255: RGBvalues(57) = 218
   RGBvalues(58) = 182: RGBvalues(59) = 255: RGBvalues(60) = 234
   RGBvalues(61) = 182: RGBvalues(62) = 255: RGBvalues(63) = 255
   RGBvalues(64) = 182: RGBvalues(65) = 234: RGBvalues(66) = 255
   RGBvalues(67) = 182: RGBvalues(68) = 218: RGBvalues(69) = 255
   RGBvalues(70) = 182: RGBvalues(71) = 198: RGBvalues(72) = 255

   ' set up two identical sets of the 24 colors in the RGBvalues array
   For I = 1 To 24 * 3
      RGBvalues(I + 24 * 3) = RGBvalues(I)
   Next I

End Sub
