{*****************************************************************************
*                                                                            *
*  RAINBOW.PAS                                                               *
*                                                                            *
*  This program demonstrates color palette cycling.                          *
*                                                                            *
*****************************************************************************}

program rainbow;

{$IFDEF VER80}
uses WinTypes, WinProcs, Messages, FGWinG;
{$ELSE}
uses WinTypes, WinProcs, FGWinG;
{$ENDIF}

const
  AppName = 'FGrainbow';

var
  cxClient, cyClient : word;
  dc    : hDC;
  hpal  : hPalette;
  hvb   : integer;
  start : integer;
  RGBvalues : array [0..2*24*3-1] of byte;    { two sets of 24 RGB triplets }

{*****************************************************************************
*                                                                            *
*  fill_color_palette                                                        *
*                                                                            *
*  Set up the colors for the application's logical palette in the RGBvalues  *
*  array. The logical palette will contain 24 non-system colors (indices 10  *
*  to 33) defining the initial RGB values for the colors being cycled.       *
*                                                                            *
*  Note that we store two identical sets of 24 RGB triplets in RGBvalues. We *
*  can then perform color cycling without having to worry about wrapping to  *
*  the start of the array because the index pointing to the starting RGB     *
*  triplet never extends beyond the first set of 24 RGB triplets.            *
*                                                                            *
*****************************************************************************}

procedure fill_color_palette;

const
  colors : array [1..24*3] of byte = (
    182,182,255, 198,182,255, 218,182,255, 234,182,255, 255,182,255,
    255,182,234, 255,182,218, 255,182,198, 255,182,182, 255,198,182,
    255,218,182, 255,234,182, 255,255,182, 234,255,182, 218,255,182,
    198,255,182, 182,255,182, 182,255,198, 182,255,218, 182,255,234,
    182,255,255, 182,234,255, 182,218,255, 182,198,255);

begin
   { set up two identical sets of the 24 colors in the RGBvalues array }
   Move(colors,RGBvalues,24*3);
   Move(colors,RGBvalues[24*3],24*3);
end;

{*****************************************************************************
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
*****************************************************************************}

function WindowProc(window : hwnd; message : word;
                    wParam : word; lParam : longint): longint; export;
var
  ps : tPaintStruct;
  color, xlen, ylen : integer;

begin

  WindowProc := 0;

  case message of

    WM_CREATE:
    begin

      { create the logical palette }

      dc := GetDC(window);
      fg_setdc(dc);
      fill_color_palette;
      hpal := fg_logpal(10,24,RGBvalues);

      { create a 640x480 virtual buffer }

      fg_vbinit;
      hvb := fg_vballoc(640,480);
      fg_vbopen(hvb);
      fg_vbcolors;

      { construct a crude image of a rainbow }

      fg_setcolor(255);
      fg_fillpage;
      fg_setclip(0,639,0,300);
      fg_move(320,300);
      xlen := 240;
      ylen := 120;
      for color := 10 to 33 do
      begin
        fg_setcolor(color);
        fg_ellipsef(xlen,ylen);
        dec(xlen,4);
        dec(ylen,3);
      end;
      fg_setcolor(255);
      fg_ellipsef(xlen,ylen);
      fg_setclip(0,639,0,479);

      { starting index into the array of color values }

      start := 0;

      Exit;
    end;

    WM_PAINT:
    begin
      BeginPaint(window,ps);
      fg_vbscale(0,fg_getmaxx,0,fg_getmaxy,0,cxClient-1,0,cyClient-1);
      EndPaint(window,ps);
      Exit;
    end;

    WM_SETFOCUS:
    begin
      fg_realize(hpal);
      InvalidateRect(window,nil,TRUE);
      Exit;
    end;

    WM_SIZE:
    begin
      cxClient := LOWORD(lParam);
      cyClient := HIWORD(lParam);
      Exit;
    end;

    WM_TIMER:
    begin
      if (GetActiveWindow = window) then
      begin
        start := (start + 3) mod 72;
        fg_setdacs(10,24,RGBvalues[start]);
        if (fg_colors > 8) then
          fg_vbscale(0,fg_getmaxx,0,fg_getmaxy,0,cxClient-1,0,cyClient-1);
      end;
      Exit;
    end;

    WM_DESTROY:
    begin
      KillTimer(window,1);
      fg_vbclose;
      fg_vbfree(hvb);
      fg_vbfin;
      DeleteObject(hpal);
      ReleaseDC(window,dc);
      PostQuitMessage(0);
      Exit;
    end;

  end;
  WindowProc := DefWindowProc(window,message,wParam,lParam);
end;

{****************************************************************************}

procedure WinMain;

var
  window      : hWnd;
  message     : tMsg;
  WindowClass : tWndClass;

begin
  if hPrevInst = 0 then
  begin
    WindowClass.style         := CS_HREDRAW OR CS_VREDRAW;
    WindowClass.lpfnWndProc   := @WindowProc;
    WindowClass.cbClsExtra    := 0;
    WindowClass.cbWndExtra    := 0;
    WindowClass.hInstance     := hInstance;
    WindowClass.hIcon         := LoadIcon(0,IDI_APPLICATION);
    WindowClass.hCursor       := LoadCursor(0,IDC_ARROW);
    WindowClass.hbrBackground := GetStockObject(WHITE_BRUSH);
    WindowClass.lpszMenuName  := nil;
    WindowClass.lpszClassName := AppName;
    if not RegisterClass(WindowClass) then Halt(255);
  end;

  window := CreateWindow(
    AppName,                    { window class name }
    'Color Cycling',            { window caption }
    WS_OVERLAPPEDWINDOW,        { window style }
    CW_USEDEFAULT,              { initial x position }
    CW_USEDEFAULT,              { initial y position }
    CW_USEDEFAULT,              { initial x size }
    CW_USEDEFAULT,              { initial y size }
    0,                          { parent window handle }
    0,                          { window menu handle }
    hInstance,                  { program instance handle }
    nil);                       { creation parameters }

  ShowWindow(window,CmdShow);
  UpdateWindow(window);

  SetTimer(window,1,50,nil);

  while GetMessage(message,0,0,0) do
  begin
    TranslateMessage(message);
    DispatchMessage(message);
  end;

  Halt(message.wParam);
end;

begin
  WinMain;
end.
