// David C. Freeman

// July 1, 1997

// Fastgraph for Windows Basic Sprite Loading for Builder C++
//
// Terms of Usage: Freely use and distribute. Let's make some Games!

//

// Dependencies: Fastgraph for Windows v. 1.0, Windows95, Borland Builder C++

//

// Description: This is an example of how to use Fastgraph to load sprites
//				and display them. It makes use of a PCX file. The file is loaded
//              into a virtual buffer off screen. Each sprite is approx 64x64.
//              I have included a template grid that can be used to place your
//              sprites in called temp64.pcx. It's real handy for determining
//              the exact location of your sprites. Removes a lot of guess work.
//              I'm using a fixed sprite pointer array to house my sprites, but
//              a linked list structure could certainly be used.
//				Check out sprites1.h for the declarations.

// Notes:

// 		-Make sure you've added the fgwbc32.lib file to your project. BC stands

// 		for Borland C++.  You'll have to add the file that applies to your

//		compiler. See the FGW docs for more information.

//

//      -When compiling, turn off the incremental linker in project

//		linker options, or you'll get all kinds of weird errors!

//

//		- This project was made within a 1024x768 display. When run

//	    on other monitors set up for lower resolutions, be sure to

//	    check the positioning of your client window. In this case, Form1.

//		Check the Left and Top variable in the object inspector to set

//      where the form appears, or the form may appear off  screen with

//      a lower	resoulution. Drove me nuts!

//

//

// DCF

//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "sprites1.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}

//---------------------------------------------------------------------------
void TForm1::Blit()
{
   // Blit takes the contents of the virtual buffer and places them
   // in the client regardless of client dimensions


	if ( (cxClient > VBWIDTH) || (cyClient > VBHEIGHT) )
  	{
     fg_vbscale(0,VBWIDTH-1,0,VBHEIGHT-1,0,cxClient-1,0,cyClient-1);
     }
    else
    fg_vbpaste(0,VBWIDTH-1,0,VBHEIGHT-1,0,cyClient-1);
}
//---------------------------------------------------------------------------

 void TForm1::Load_sprites()
 {
     struct SPRITE *new_sprite;


         fg_loadpcx("ships.pcx",2);  // Load the PCX file into the virt. buffer
                                     // using the files palette

		  // Get sprite 0

	   	  new_sprite = new SPRITE;  // allocate sprite space
          fg_move(1,64);   // move to the first image
		  fg_getimage((*new_sprite).bitmap, 64, 64);// cut one images
          sprite[0] = new_sprite;



         // Get sprite 1

	   	  new_sprite = new SPRITE;  // allocate sprite space
          fg_move(66,64);   // move to the second image
		  fg_getimage((*new_sprite).bitmap, 64, 64);// cut one images
          sprite[1] = new_sprite;


          // Get sprite 2

	   	  new_sprite = new SPRITE;  // allocate sprite space
          fg_move(131,64);   // move to the third image
		  fg_getimage((*new_sprite).bitmap, 64, 64);// cut one images
          sprite[2] = new_sprite;


          // Get sprite 3

	   	  new_sprite = new SPRITE;  // allocate sprite space
          fg_move(196,64);   // move to the fourth image
		  fg_getimage((*new_sprite).bitmap, 64, 64);// cut one images
          sprite[3] = new_sprite;



          // Get sprite 4

	   	  new_sprite = new SPRITE;  // allocate sprite space
		  fg_move(1,129);   // move to the fifth image
		  fg_getimage((*new_sprite).bitmap, 64, 64);// cut one images
          sprite[4] = new_sprite;


       fg_erase();    // erase content of Virtual buffer



 }



//---------------------------------------------------------------------------
void __fastcall TForm1::Sprite1Click(TObject *Sender)
{
// this function places the sprites in the virtual buffer and blits
// them to the client area when the button object is clicked

     //Place image 1
  	fg_move(10,40);       // this image will be clipped
	fg_clpimage((*sprite[0]).bitmap,64,64);   // use clip image to avoid
     										// writing to regions outside the
                                            // virtual buffer boundary.
                                            // this fucnction will test for
                                            // illegal writes and clip
                                            // accordingly
     //Place image 2
    fg_move(190,100);
    fg_clpimage((*sprite[1]).bitmap,64,64);

     //Place image 3
    fg_move(190,200);
    fg_clpimage((*sprite[2]).bitmap,64,64);

    //Place image 4
    fg_move(300,400);
    fg_clpimage((*sprite[3]).bitmap,64,64);

    //Place image 5   World sprite
    fg_move(400,300);
    fg_clpimage((*sprite[4]).bitmap,64,64);

     //Place image 1  again
  	fg_move(500,350);       
	fg_clpimage((*sprite[0]).bitmap,64,64);

	  	Blit();   // place virt. buffer contents in client area

}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormDestroy(TObject *Sender)
{
  fg_vbclose();
       // clean up
    free(sprite[4]);  // Free the sprites highest to lowest
    free(sprite[3]);
    free(sprite[2]);
   	free(sprite[1]);
    free(sprite[0]);
	free(sprite);

    fg_vbfree(hvb);     // free the virtual buffer
    fg_vbfin();
    DeleteObject(hpal);
    ReleaseDC(Form1,hdc);
	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormResize(TObject *Sender)
{

  cxClient = ClientWidth;
 cyClient = ClientHeight;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormPaint(TObject *Sender)
{
   fg_vbscale(0,fg_getmaxx(),0,fg_getmaxy(),0,cxClient-1,0,cyClient-1);	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormActivate(TObject *Sender)
{
   hdc	= GetDeviceContext(Form1); // assign the DC to this variable
    fg_setdc(hdc);  // tell FGW this is the device to be used (window, client)
    hpal = fg_defpal(); // assign a default palette to this varible
    fg_realize(hpal); // tell FGW about this palette

    fg_vbinit();     // initialize the virtual buffer
    hvb = fg_vballoc(VBWIDTH,VBHEIGHT); // get 640x480 worth of memory
    fg_vbopen(hvb); // open the buffer
    fg_vbcolors();  // set the color in FGW
    Load_sprites();  // Load the sprites from the pcx file
                     // no checking for the existence of the file has been
                     // included so the file better be there! (ships.pcx)

    Application->OnActivate = OnActivate;
	
}
//--------------------------------------------------------------------------- 