/****************************************************************************\
*                                                                            *
*  BITMAP16.C                                                                *
*                                                                            *
*  This program demonstrates how to translate a 16-color bitmap to the 256-  *
*  color format, and display the resulting 256-color image.                  *
*                                                                            *
\****************************************************************************/

#include <fgwin.h>

#define WIDTH  320
#define HEIGHT 200

// 40x20 pixel (20x20 byte) 16-color bitmapped image of a bird

char bird16[] = {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x11,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x1F,0x17,0x17,0x11,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0xFF,0x17,0x17,0x1F,0x10,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x1F,0xFF,0xF1,0xF1,0xFF,0x10,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x11,
    0x1F,0xFF,0xF1,0xF1,0xF1,0x00,0x00,0x00,0x01,0x10,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xFF,
    0x1F,0xFF,0xFF,0xFF,0xF1,0x00,0x11,0x11,0x17,0x10,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x1F,0xF1,
    0xFF,0xFF,0xFF,0xFF,0x10,0x01,0xFF,0xFF,0xF1,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xF1,0xFF,
    0x1F,0xFF,0xFF,0xFF,0x10,0x1F,0xFF,0xFF,0x10,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xF1,0xFF,0x1F,
    0xFF,0xFF,0xFF,0xFF,0x10,0x1F,0xFF,0xF1,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFF,0x1F,0xF1,
    0xFF,0xFF,0xFF,0xFF,0x11,0xFF,0xFF,0x10,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xF1,0xFF,0x1F,
    0xFF,0xFF,0xFF,0xF1,0xFF,0xFF,0xF1,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x01,0x1F,0xF1,0xFF,0xFF,
    0xFF,0xFF,0xFF,0xF1,0xFF,0x1F,0x10,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0xFF,0xFF,0xFF,
    0xFF,0xFF,0xFF,0xF1,0xFF,0xFF,0x10,0x00,0x00,0x00,
    0x01,0x11,0x10,0x00,0x00,0x1F,0xF1,0xFF,0xFF,0xFF,
    0xFF,0xFF,0xFF,0xFF,0xF1,0xF1,0x00,0x00,0x00,0x00,
    0x17,0x77,0x71,0x11,0x10,0x11,0xFF,0xFF,0xFF,0xFF,
    0xFF,0xFF,0xF1,0xFF,0xF1,0x11,0x10,0x00,0x00,0x00,
    0x01,0x77,0x77,0x77,0x71,0xFF,0x1F,0xFF,0xFF,0xFF,
    0xFF,0xFF,0x1F,0xFF,0x17,0x77,0x71,0x11,0x11,0x10,
    0x00,0x11,0x11,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x14,0x41,0x00,
    0x00,0x00,0x00,0x11,0x11,0x11,0x11,0xFF,0xFF,0xFF,
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x4F,0xF1,0x10,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x11,0xFF,0xFF,
    0xFF,0xFF,0xFF,0xF1,0x11,0x1F,0xFF,0x10,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x11,0x11,
    0x11,0x11,0x11,0x10,0x00,0x01,0x11,0x00,0x00,0x00
};
char translation[] = {0,10,12,13,14,15,16,17,18,19,20,21,22,23,24,25};
char bird256[40*20];

long WINAPI _export WindowProc(HWND,UINT,UINT,LONG);

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
{
   static char szAppName[] = "FGbitmap16";
   HWND        window;
   MSG         msg;
   WNDCLASS    wndclass;

   if (!hPrevInstance)
   {
      wndclass.style         = CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc   = WindowProc;
      wndclass.cbClsExtra    = 0;
      wndclass.cbWndExtra    = 0;
      wndclass.hInstance     = hInstance;
      wndclass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
      wndclass.hCursor       = LoadCursor(NULL,IDC_ARROW);
      wndclass.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
      wndclass.lpszMenuName  = NULL;
      wndclass.lpszClassName = szAppName;
      RegisterClass (&wndclass);
   }

   window = CreateWindow(szAppName, // window class name
      "16-Color Bitmap Demo",  // window caption
      WS_OVERLAPPEDWINDOW,     // window style
      CW_USEDEFAULT,           // initial x position
      CW_USEDEFAULT,           // initial y position
      CW_USEDEFAULT,           // initial x size
      CW_USEDEFAULT,           // initial y size
      NULL,                    // parent window handle
      NULL,                    // window menu handle
      hInstance,               // program instance handle
      NULL);                   // creation parameters

   ShowWindow(window,nCmdShow);
   UpdateWindow(window);

   while (GetMessage(&msg,NULL,0,0))
   {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   return msg.wParam;
}

/****************************************************************************\
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
\****************************************************************************/

HDC      hdc;
HPALETTE hpal;
int      hvb;
UINT     cxClient, cyClient;

long WINAPI _export WindowProc(HWND window, UINT message,
                               UINT wParam, LONG lParam)
{
   PAINTSTRUCT ps;
   register int i;

   switch (message)
   {
      case WM_CREATE:
         hdc = GetDC(window);
         fg_setdc(hdc);
         hpal = fg_defpal();
         fg_realize(hpal);

         fg_vbinit();
         hvb = fg_vballoc(WIDTH,HEIGHT);
         fg_vbopen(hvb);
         fg_vbcolors();

         fg_unpack(bird16,bird256,20*20);
         for (i = 0; i < 40*20; i++)
            bird256[i] = translation[bird256[i]];
            
         fg_setcolor(20);
         fg_fillpage();
         fg_move(WIDTH/2-20,HEIGHT/2+10);
         fg_drwimage(bird256,40,20);

         return 0;

      case WM_PAINT:
         BeginPaint(window,&ps);
         fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
         EndPaint(window,&ps);
         return 0;

      case WM_SETFOCUS:
         fg_realize(hpal);
         InvalidateRect(window,NULL,TRUE);
         return 0;

      case WM_SIZE:
         cxClient = LOWORD(lParam);
         cyClient = HIWORD(lParam);
         return 0;

      case WM_DESTROY:
         fg_vbclose();
         fg_vbfree(hvb);
         fg_vbfin();
         DeleteObject(hpal);
         ReleaseDC(window,hdc);
         PostQuitMessage(0);
         return 0;
   }
   return DefWindowProc(window,message,wParam,lParam);
}
