/****************************************************************************\
*                                                                            *
*  CBDEMO.C                                                                  *
*                                                                            *
*  This program demonstrates how to exchange information between the active  *
*  virtual buffer and the Windows clipboard.                                 *
*                                                                            *
\****************************************************************************/

#include <fgwin.h>
#include "cbdemo.h"

#define WIDTH  320
#define HEIGHT 200

long WINAPI _export WindowProc(HWND,UINT,UINT,LONG);

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
{
   static char szAppName[] = "FGcbdemo";
   HWND        window;
   MSG         msg;
   WNDCLASS    wndclass;

   if (!hPrevInstance)
   {
      wndclass.style         = CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc   = WindowProc;
      wndclass.cbClsExtra    = 0;
      wndclass.cbWndExtra    = 0;
      wndclass.hInstance     = hInstance;
      wndclass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
      wndclass.hCursor       = LoadCursor(NULL,IDC_ARROW);
      wndclass.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
      wndclass.lpszMenuName  = szAppName;
      wndclass.lpszClassName = szAppName;
      RegisterClass (&wndclass);
   }

   window = CreateWindow(szAppName, // window class name
      "Clipboard Demo",        // window caption
      WS_OVERLAPPEDWINDOW,     // window style
      CW_USEDEFAULT,           // initial x position
      CW_USEDEFAULT,           // initial y position
      CW_USEDEFAULT,           // initial x size
      CW_USEDEFAULT,           // initial y size
      NULL,                    // parent window handle
      NULL,                    // window menu handle
      hInstance,               // program instance handle
      NULL);                   // creation parameters

   ShowWindow(window,nCmdShow);
   UpdateWindow(window);

   while (GetMessage(&msg,NULL,0,0))
   {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   return msg.wParam;
}

/****************************************************************************\
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
\****************************************************************************/

HDC      hdc;
HMENU    hmenu;
HPALETTE hpal;
int      hvb;
UINT     cxClient, cyClient;

long WINAPI _export WindowProc(HWND window, UINT message,
                               UINT wParam, LONG lParam)
{
   PAINTSTRUCT ps;

   switch (message)
   {
      case WM_CREATE:
         hdc = GetDC(window);
         fg_setdc(hdc);
         hpal = fg_defpal();
         fg_realize(hpal);

         fg_vbinit();
         hvb = fg_vballoc(WIDTH,HEIGHT);
         fg_vbopen(hvb);
         fg_vbcolors();

         fg_showpcx("MOUSE.PCX",2);

         hmenu = GetMenu(window);
         return 0;

      case WM_COMMAND:
         switch (wParam)
         {
            case IDM_CUT:
               fg_vb2clip(0,WIDTH-1,0,HEIGHT-1);
               fg_erase();
               fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
               EnableMenuItem(hmenu,IDM_PASTE,MF_ENABLED);
               DrawMenuBar(window);
               return 0;

            case IDM_PASTE:
               fg_clip2vb(0,WIDTH-1,0,HEIGHT-1,0);
               fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
               return 0;

            case IDM_QUIT:
               SendMessage(window,WM_CLOSE,0,0L);
               return 0;
         }
         break;

      case WM_PAINT:
         BeginPaint(window,&ps);
         fg_vbscale(0,WIDTH-1,0,HEIGHT-1,0,cxClient-1,0,cyClient-1);
         EndPaint(window,&ps);
         return 0;

      case WM_SETFOCUS:
         fg_realize(hpal);
         InvalidateRect(window,NULL,TRUE);
         return 0;

      case WM_SIZE:
         cxClient = LOWORD(lParam);
         cyClient = HIWORD(lParam);
         return 0;

      case WM_DESTROY:
         fg_vbclose();
         fg_vbfree(hvb);
         fg_vbfin();
         DeleteObject(hpal);
         ReleaseDC(window,hdc);
         PostQuitMessage(0);
         return 0;
   }
   return DefWindowProc(window,message,wParam,lParam);
}
