/****************************************************************************\
*                                                                            *
*  FIRSTMFC.CPP                                                              *
*                                                                            *
*  This is a version of the first Fastgraph for Windows example program      *
*  written for the Microsoft Foundation Class application framework. It is   *
*  not intended as an MFC tutorial, but rather to show how to integrate      *
*  Fastgraph for Windows functions in MFC programs.                          *
*                                                                            *
\****************************************************************************/

#include <afxwin.h>
#include <fgwin.h>

HDC      hdc;
HPALETTE hpal;
UINT     cxClient, cyClient;
int      hvb;

/****************************************************************************\
*                                                                            *
*  Class declarations                                                        *
*                                                                            *
\****************************************************************************/

class CMyApp : public CWinApp
{
public:
   virtual BOOL InitInstance();
};

class CMyWindow : public CFrameWnd
{
public:
   CMyWindow();
protected:
   // message response functions
   afx_msg int  OnCreate(LPCREATESTRUCT);
   afx_msg void OnPaint();
   afx_msg void OnSetFocus(CWnd*);
   afx_msg void OnSize(UINT,int,int);
   afx_msg void OnDestroy();
   DECLARE_MESSAGE_MAP()
};

// response table definition
BEGIN_MESSAGE_MAP(CMyWindow, CFrameWnd)
   ON_WM_CREATE()
   ON_WM_PAINT()
   ON_WM_SETFOCUS()
   ON_WM_SIZE()
   ON_WM_DESTROY()
END_MESSAGE_MAP()


CMyApp NEAR theApp;

BOOL CMyApp::InitInstance()
{
   m_pMainWnd = new CMyWindow();
   m_pMainWnd->ShowWindow(m_nCmdShow);
   m_pMainWnd->UpdateWindow();
   return TRUE;
}

CMyWindow::CMyWindow()
{
   Create("AfxFrameOrView","First Fastgraph for Windows Program");
}

/****************************************************************************\
*                                                                            *
*  OnCreate()                                                                *
*                                                                            *
*  Takes the place of the WM_CREATE message handler.                         *
*                                                                            *
\****************************************************************************/

int CMyWindow::OnCreate(LPCREATESTRUCT lpCS)
{
   CFrameWnd::OnCreate(lpCS);
   hdc = ::GetDC(CMyWindow::m_hWnd);
   fg_setdc(hdc);
   hpal = fg_defpal();
   fg_realize(hpal);

   fg_vbinit();
   hvb = fg_vballoc(320,200);
   fg_vbopen(hvb);
   fg_vbcolors();

   return TRUE;
}

/****************************************************************************\
*                                                                            *
*  OnPaint()                                                                 *
*                                                                            *
*  Takes the place of the WM_PAINT message handler.                          *
*                                                                            *
\****************************************************************************/

void CMyWindow::OnPaint()
{
   CPaintDC dc(this);

   fg_vbscale(0,fg_getmaxx(),0,fg_getmaxy(),0,cxClient-1,0,cyClient-1);
}

/****************************************************************************\
*                                                                            *
*  OnSetFocus()                                                              *
*                                                                            *
*  Takes the place of the WM_SETFOCUS message handler.                       *
*                                                                            *
\****************************************************************************/

void CMyWindow::OnSetFocus(CWnd*)
{
   fg_realize(hpal);
   Invalidate(0);
}

/****************************************************************************\
*                                                                            *
*  OnSize()                                                                  *
*                                                                            *
*  Takes the place of the WM_SIZE message handler.                           *
*                                                                            *
\****************************************************************************/

void CMyWindow::OnSize(UINT, int cx, int cy)
{
   cxClient = cx;
   cyClient = cy;
}

/****************************************************************************\
*                                                                            *
*  OnDestroy()                                                               *
*                                                                            *
*  Takes the place of the WM_DESTROY message handler.                        *
*                                                                            *
\****************************************************************************/

void CMyWindow::OnDestroy()
{
   fg_vbclose();
   fg_vbfree(hvb);
   fg_vbfin();
   ::DeleteObject(hpal);
   ::ReleaseDC(CMyWindow::m_hWnd,hdc);
   CFrameWnd::OnDestroy();
}
