/****************************************************************************\
*                                                                            *
*  FIRSTOWL.CPP                                                              *
*                                                                            *
*  This is a version of the first Fastgraph for Windows example program      *
*  written for Borland's OWL application framework. It is not intended as an *
*  OWL tutorial, but rather to show how to integrate Fastgraph for Windows   *
*  functions in OWL programs.                                                *
*                                                                            *
\****************************************************************************/

#include <owl\applicat.h>
#include <owl\framewin.h>
#include <fgwin.h>

HDC      hdc;
HPALETTE hpal;
UINT     cxClient, cyClient;
int      hvb;

/****************************************************************************\
*                                                                            *
*  Class declarations                                                        *
*                                                                            *
\****************************************************************************/

class TMyApp : public TApplication
{
public:
   TMyApp() : TApplication() {}
   void InitMainWindow();
};

class TMyWindow : public TWindow
{
public:
   TMyWindow(TWindow *parent = 0);
   void SetupWindow();                 // WM_CREATE messages
   void Paint(TDC&, bool, TRect&);     // WM_PAINT messages
   void CleanupWindow();               // WM_DESTROY messages
protected:
   // message response functions
   void EvSetFocus(HWND);              // WM_SETFOCUS messages
   void EvSize(UINT, TSize&);          // WM_SIZE messages
   DECLARE_RESPONSE_TABLE(TMyWindow);
};

// response table definition
DEFINE_RESPONSE_TABLE1(TMyWindow, TWindow)
   EV_WM_SETFOCUS,
   EV_WM_SIZE,
END_RESPONSE_TABLE;

void TMyApp::InitMainWindow()
{
   SetMainWindow(new TFrameWindow(NULL,
      "First Fastgraph for Windows Program", new TMyWindow));
}

TMyWindow::TMyWindow(TWindow *parent)
{
   Init(parent,0,0);
}

/****************************************************************************\
*                                                                            *
*  SetupWindow()                                                             *
*                                                                            *
*  Takes the place of the WM_CREATE message handler.                         *
*                                                                            *
\****************************************************************************/

void TMyWindow::SetupWindow()
{
   TWindow::SetupWindow();
   hdc = GetDC(TMyWindow::HWindow);
   fg_setdc(hdc);
   hpal = fg_defpal();
   fg_realize(hpal);

   fg_vbinit();
   hvb = fg_vballoc(320,200);
   fg_vbopen(hvb);
   fg_vbcolors();
}

/****************************************************************************\
*                                                                            *
*  Paint()                                                                   *
*                                                                            *
*  Takes the place of the WM_PAINT message handler.                          *
*                                                                            *
\****************************************************************************/

void TMyWindow::Paint(TDC&, bool, TRect&)
{
   fg_vbscale(0,fg_getmaxx(),0,fg_getmaxy(),0,cxClient-1,0,cyClient-1);
}

/****************************************************************************\
*                                                                            *
*  EvSetFocus()                                                              *
*                                                                            *
*  Takes the place of the WM_SETFOCUS message handler.                       *
*                                                                            *
\****************************************************************************/

void TMyWindow::EvSetFocus(HWND)
{
   fg_realize(hpal);
   Invalidate(0);
}

/****************************************************************************\
*                                                                            *
*  EvSize()                                                                  *
*                                                                            *
*  Takes the place of the WM_SIZE message handler.                           *
*                                                                            *
\****************************************************************************/

void TMyWindow::EvSize(UINT, TSize &size)
{
   cxClient = size.cx;
   cyClient = size.cy;
   Invalidate(0);
}

/****************************************************************************\
*                                                                            *
*  CleanupWindow()                                                           *
*                                                                            *
*  Takes the place of the WM_DESTROY message handler.                        *
*                                                                            *
\****************************************************************************/

void TMyWindow::CleanupWindow()
{
   fg_vbclose();
   fg_vbfree(hvb);
   fg_vbfin();
   DeleteObject(hpal);
   ReleaseDC(TMyWindow::HWindow,hdc);
   TWindow::CleanupWindow();
}

/****************************************************************************\
*                                                                            *
*  OwlMain()                                                                 *
*                                                                            *
\****************************************************************************/

int OwlMain(int,char*[])
{
   return TMyApp().Run();
}
