/****************************************************************************\
*                                                                            *
*  FONTDEMO.C                                                                *
*                                                                            *
*  This program shows how use Windows stock fonts in Fastgraph for Windows,  *
*  and also how to create and use a Windows logical font. The logical font   *
*  is a 24x12 script font.                                                   *
*                                                                            *
\****************************************************************************/

#include <fgwin.h>
#include <stdlib.h>

#define WIDTH  320
#define HEIGHT 200

long WINAPI _export WindowProc(HWND,UINT,UINT,LONG);

LOGFONT lf;

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
{
   static char szAppName[] = "FGfontdemo";
   HWND        window;
   MSG         msg;
   WNDCLASS    wndclass;

   if (!hPrevInstance)
   {
      wndclass.style         = CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc   = WindowProc;
      wndclass.cbClsExtra    = 0;
      wndclass.cbWndExtra    = 0;
      wndclass.hInstance     = hInstance;
      wndclass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
      wndclass.hCursor       = LoadCursor (NULL,IDC_ARROW);
      wndclass.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
      wndclass.lpszMenuName  = NULL;
      wndclass.lpszClassName = szAppName;
      RegisterClass (&wndclass);
   }

   lf.lfHeight = 24;                // character height in pixels
   lf.lfWidth = 12;                 // character width in pixels
   lf.lfEscapement = 0;             // orientation of next character
   lf.lfOrientation = 0;            // orientation of first character
   lf.lfWeight = FW_NORMAL;         // normal thickness
   lf.lfItalic = FALSE;             // not italic characters
   lf.lfUnderline = FALSE;          // not underlined characters
   lf.lfStrikeOut = FALSE;          // not strikeout characters
   lf.lfCharSet = OEM_CHARSET;      // OEM character set
   lf.lfOutPrecision = 0;           // default output precision
   lf.lfClipPrecision = 0;          // default clipping precision
   lf.lfQuality = DEFAULT_QUALITY;  // default scaling quality
   lf.lfPitchAndFamily = FF_SCRIPT; // default pitch, script font family
   lstrcpy(lf.lfFaceName,"script"); // script typeface

   window = CreateWindow(szAppName, // window class name
      "Fastgraph for Windows Font Demo", // window caption
      WS_OVERLAPPEDWINDOW,          // window style
      CW_USEDEFAULT,                // initial x position
      CW_USEDEFAULT,                // initial y position
      WIDTH,                        // initial x size
      HEIGHT,                       // initial y size
      NULL,                         // parent window handle
      NULL,                         // window menu handle
      hInstance,                    // program instance handle
      NULL);                        // creation parameters

   ShowWindow(window,nCmdShow);
   UpdateWindow(window);

   while (GetMessage(&msg,NULL,0,0))
   {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   return msg.wParam;
}

/****************************************************************************\
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
\****************************************************************************/

HDC      hdc;
HFONT    hfont;
HPALETTE hpal;
UINT     cxClient, cyClient;
int      hvb;

long WINAPI _export WindowProc(HWND window, UINT message,
                               UINT wParam, LONG lParam)
{
   PAINTSTRUCT ps;
   register int x;

   switch (message)
   {
      case WM_CREATE:
         hdc = GetDC(window);
         fg_setdc(hdc);
         hpal = fg_defpal();
         fg_realize(hpal);

         fg_vbinit();
         hvb = fg_vballoc(WIDTH,HEIGHT);
         fg_vbopen(hvb);
         fg_vbcolors();

         fg_setcolor(24);
         fg_fillpage();

         hfont = CreateFontIndirect(&lf);
         return 0;

      case WM_PAINT:
         BeginPaint(window,&ps);
         fg_vbscale(0,fg_getmaxx(),0,fg_getmaxy(),0,cxClient-1,0,cyClient-1);
         fg_setcolor(19);
         x = fg_xclient(20);

         fg_move(x,fg_yclient(20));
         fg_fontload(10);
         fg_print("OEM fixed font",14);

         fg_move(x,fg_yclient(40));
         fg_fontload(11);
         fg_print("ANSI fixed font",15);

         fg_move(x,fg_yclient(60));
         fg_fontload(12);
         fg_print("ANSI var font",13);

         fg_move(x,fg_yclient(80));
         fg_fontload(13);
         fg_print("system font",11);

         fg_move(x,fg_yclient(100));
         fg_fontload(14);
         fg_print("device default font",19);

         fg_move(x,fg_yclient(120));
         fg_fontload(16);
         fg_print("system fixed font",17);

         fg_move(x,fg_yclient(160));
         fg_logfont(hfont);
         fg_print("script font",11);

         EndPaint(window,&ps);
         return 0;

      case WM_SETFOCUS:
         fg_realize(hpal);
         InvalidateRect(window,NULL,TRUE);
         return 0;

      case WM_SIZE:
         cxClient = LOWORD(lParam);
         cyClient = HIWORD(lParam);
         return 0;

      case WM_DESTROY:
         fg_vbclose();
         fg_vbfree(hvb);
         fg_vbfin();
         DeleteObject(hfont);
         DeleteObject(hpal);
         ReleaseDC(window,hdc);
         PostQuitMessage(0);
         return 0;
   }
   return DefWindowProc(window,message,wParam,lParam);
}
