/****************************************************************************\
*                                                                            *
*  GDIDEMO.C                                                                 *
*                                                                            *
*  This program shows how to use Windows GDI functions to write to a virtual *
*  buffer. It uses GDI functions to display a cross-hatched rectangle with a *
*  border, something that would require construction from several graphics   *
*  primitives if using Fastgraph for Windows drawing functions only.         *
*                                                                            *
*  Only the Fastgraph for Windows WinG support libraries allow writing to a  *
*  virtual buffer with GDI functions.                                        *
*                                                                            *
\****************************************************************************/

#include <fgwin.h>

long WINAPI _export WindowProc(HWND,UINT,UINT,LONG);

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
{
   static char szAppName[] = "FGgdidemo";
   HBRUSH      hBrush;
   HDC         hDIB;
   HPEN        hPen;
   HWND        window;
   MSG         msg;
   WNDCLASS    wndclass;

   if (!hPrevInstance)
   {
      wndclass.style         = CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc   = WindowProc;
      wndclass.cbClsExtra    = 0;
      wndclass.cbWndExtra    = 0;
      wndclass.hInstance     = hInstance;
      wndclass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
      wndclass.hCursor       = LoadCursor(NULL,IDC_ARROW);
      wndclass.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
      wndclass.lpszMenuName  = NULL;
      wndclass.lpszClassName = szAppName;
      RegisterClass(&wndclass);
   }

   window = CreateWindow(szAppName,     // window class name
      "Fastgraph for Windows GDI Demo", // window caption
      WS_OVERLAPPEDWINDOW,     // window style
      CW_USEDEFAULT,           // initial x position
      CW_USEDEFAULT,           // initial y position
      CW_USEDEFAULT,           // initial x size
      CW_USEDEFAULT,           // initial y size
      NULL,                    // parent window handle
      NULL,                    // window menu handle
      hInstance,               // program instance handle
      NULL);                   // creation parameters

   // use FG to fill the virtual buffer with light green pixels
   fg_setcolor(20);
   fg_fillpage();

   // fg_getdc() returns the WinG device context to which the GDI
   // functions will draw, or zero if WinG is not available
   hDIB = fg_getdc();
   if (hDIB == 0)
   {
      MessageBox(window,"WinG not available!","GDIDEMO",MB_ICONSTOP|MB_OK);
      return 0;
   }

   // use Windows GDI functions to display a cross-hatched
   // rectangle with blue border in the virtual buffer
   hPen = CreatePen(PS_SOLID,3,RGB(0,0,255));
   hBrush = CreateHatchBrush(HS_DIAGCROSS,RGB(255,0,0));
   SelectObject(hDIB,hPen);
   SelectObject(hDIB,hBrush);
   Rectangle(hDIB,20,20,50,50);
   DeleteObject(hPen);
   DeleteObject(hBrush);

   ShowWindow(window,nCmdShow);
   UpdateWindow(window);

   while (GetMessage(&msg,NULL,0,0))
   {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   return msg.wParam;
}

/****************************************************************************\
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
\****************************************************************************/

HDC      hdc;
HPALETTE hpal;
UINT     cxClient, cyClient;
int      hvb;

long WINAPI _export WindowProc(HWND window, UINT message,
                               UINT wParam, LONG lParam)
{
   PAINTSTRUCT ps;

   switch (message)
   {
      case WM_CREATE:
         hdc = GetDC(window);
         fg_setdc(hdc);
         hpal = fg_defpal();
         fg_realize(hpal);

         fg_vbinit();
         hvb = fg_vballoc(320,200);
         fg_vbopen(hvb);
         fg_vbcolors();

         return 0;

      case WM_PAINT:
         BeginPaint(window,&ps);
         fg_vbscale(0,fg_getmaxx(),0,fg_getmaxy(),0,cxClient-1,0,cyClient-1);
         EndPaint(window,&ps);
         return 0;

      case WM_SETFOCUS:
         fg_realize(hpal);
         InvalidateRect(window,NULL,TRUE);
         return 0;

      case WM_SIZE:
         cxClient = LOWORD(lParam);
         cyClient = HIWORD(lParam);
         return 0;

      case WM_DESTROY:
         fg_vbclose();
         fg_vbfree(hvb);
         fg_vbfin();
         DeleteObject(hpal);
         ReleaseDC(window,hdc);
         PostQuitMessage(0);
         return 0;
   }
   return DefWindowProc(window,message,wParam,lParam);
}
