/****************************************************************************\
*                                                                            *
*  KBDEMO.C                                                                  *
*                                                                            *
*  This program shows how to pan the contents of a virtual buffer through    *
*  a smaller window using the low-level keyboard handler.                    *
*                                                                            *
\****************************************************************************/

#include <fgwin.h>

#define WIDTH  640
#define HEIGHT 480

long WINAPI _export WindowProc(HWND,UINT,UINT,LONG);
void check_for_panning();

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
{
   static char szAppName[] = "FGkbdemo";
   HWND        window;
   MSG         msg;
   WNDCLASS    wndclass;

   if (!hPrevInstance)
   {
      wndclass.style         = CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc   = WindowProc;
      wndclass.cbClsExtra    = 0;
      wndclass.cbWndExtra    = 0;
      wndclass.hInstance     = hInstance;
      wndclass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
      wndclass.hCursor       = LoadCursor (NULL,IDC_ARROW);
      wndclass.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
      wndclass.lpszMenuName  = NULL;
      wndclass.lpszClassName = szAppName;
      RegisterClass (&wndclass);
   }

   window = CreateWindow(szAppName,      // window class name
      "Keyboard Handler Demo", // window caption
      WS_OVERLAPPEDWINDOW,     // window style
      CW_USEDEFAULT,           // initial x position
      CW_USEDEFAULT,           // initial y position
      WIDTH/2,                 // initial x size
      HEIGHT/2,                // initial y size
      NULL,                    // parent window handle
      NULL,                    // window menu handle
      hInstance,               // program instance handle
      NULL);                   // creation parameters

   ShowWindow(window,nCmdShow);
   UpdateWindow(window);

   // The message loop processes entries placed in the message queue.
   // When no message is ready, call check_for_panning() to check if
   // we want to perform panning.

   while (TRUE)
   {
      if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
      {
         if (msg.message == WM_QUIT)
            break;
         else
         {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
         }
      }
      else
         check_for_panning();
   }

   return msg.wParam;
}

/****************************************************************************\
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
\****************************************************************************/

HDC      hdc;
HPALETTE hpal;
UINT     cxClient, cyClient;
int      hvb;
int      x, y;
int      xlimit, ylimit;
int      CanGoLeft, CanGoRight, CanGoUp, CanGoDown;

long WINAPI _export WindowProc(HWND window, UINT message,
                               UINT wParam, LONG lParam)
{
   PAINTSTRUCT ps;

   switch (message)
   {
      case WM_CREATE:
         hdc = GetDC(window);
         fg_setdc(hdc);
         hpal = fg_defpal();
         fg_realize(hpal);

         fg_vbinit();
         hvb = fg_vballoc(WIDTH,HEIGHT);
         fg_vbopen(hvb);
         fg_vbcolors();

         fg_showbmp("PORCH.BMP",0);
         x = y = 0;
         CanGoLeft = CanGoUp = TRUE;
         CanGoRight = CanGoDown = FALSE;

         return 0;

      case WM_PAINT:
         BeginPaint(window,&ps);
         fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
         EndPaint(window,&ps);
         return 0;

      case WM_SETFOCUS:
         fg_realize(hpal);
         InvalidateRect(window,NULL,TRUE);
         return 0;

      case WM_SIZE:
         cxClient = LOWORD(lParam);
         cyClient = HIWORD(lParam);
         if (cxClient < WIDTH)
         {
            xlimit = WIDTH - cxClient;
            if (x < xlimit) CanGoLeft = TRUE;
            if (x > 0)      CanGoRight = TRUE;
         }
         else
         {
            xlimit = 0;
            CanGoLeft = CanGoRight = FALSE;
         }
         if (cyClient < HEIGHT)
         {
            ylimit = HEIGHT - cyClient;
            if (y < ylimit) CanGoUp = TRUE;
            if (y > 0)      CanGoDown = TRUE;
         }
         else
         {
            ylimit = 0;
            CanGoUp = CanGoDown = FALSE;
         }
         return 0;

      case WM_DESTROY:
         fg_vbclose();
         fg_vbfree(hvb);
         fg_vbfin();
         DeleteObject(hpal);
         ReleaseDC(window,hdc);
         PostQuitMessage(0);
         return 0;
   }
   return DefWindowProc(window,message,wParam,lParam);
}

/****************************************************************************\
*                                                                            *
*  The check_for_panning() function checks if any of the four arrow keys are *
*  pressed, and if so, pans in that direction if possible. It is called from *
*  the message loop in WinMain when no messages are waiting.                 *
*                                                                            *
\****************************************************************************/

#define KB_ESCAPE 1
#define KB_LEFT  75
#define KB_RIGHT 77
#define KB_UP    72
#define KB_DOWN  80

void check_for_panning()
{
   if (fg_kbtest(KB_LEFT) && CanGoLeft)
   {
      if (x == 0) CanGoRight = TRUE;
      x++;
      fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
      if (x == xlimit) CanGoLeft = FALSE;
   }

   else if (fg_kbtest(KB_RIGHT) && CanGoRight)
   {
      if (x == xlimit) CanGoLeft = TRUE;
      x--;
      fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
      if (x == 0) CanGoRight = FALSE;
   }

   else if (fg_kbtest(KB_UP) && CanGoUp)
   {
      if (y == 0) CanGoDown = TRUE;
      y++;
      fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
      if (y == ylimit) CanGoUp = FALSE;
   }

   else if (fg_kbtest(KB_DOWN) && CanGoDown)
   {
      if (y == ylimit) CanGoUp = TRUE;
      y--;
      fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
      if (y == 0) CanGoDown = FALSE;
   }

   else if (fg_kbtest(KB_ESCAPE))
   {
      x = y = 0;
      fg_vbpaste(0,WIDTH-1,0,HEIGHT-1,0,HEIGHT-1);
      if (xlimit > 0) CanGoLeft = TRUE;
      if (ylimit > 0) CanGoUp = TRUE;
      CanGoRight = CanGoDown = FALSE;
   }
}
