/****************************************************************************\
*                                                                            *
*  PANNER.C                                                                  *
*                                                                            *
*  This program shows how to pan the contents of a virtual buffer through    *
*  a smaller window.                                                         *
*                                                                            *
\****************************************************************************/

#include <fgwin.h>
#include "panner.h"

#define WIDTH  640
#define HEIGHT 480

long WINAPI _export WindowProc(HWND,UINT,UINT,LONG);

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
{
   static char szAppName[] = "FGpanner";
   HWND        window;
   MSG         msg;
   WNDCLASS    wndclass;

   if (!hPrevInstance)
   {
      wndclass.style         = CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc   = WindowProc;
      wndclass.cbClsExtra    = 0;
      wndclass.cbWndExtra    = 0;
      wndclass.hInstance     = hInstance;
      wndclass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
      wndclass.hCursor       = LoadCursor (NULL,IDC_ARROW);
      wndclass.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
      wndclass.lpszMenuName  = szAppName;
      wndclass.lpszClassName = szAppName;
      RegisterClass (&wndclass);
   }

   window = CreateWindow(szAppName,      // window class name
      "Panning Demo",          // window caption
      WS_OVERLAPPEDWINDOW,     // window style
      CW_USEDEFAULT,           // initial x position
      CW_USEDEFAULT,           // initial y position
      WIDTH/2,                 // initial x size
      HEIGHT/2,                // initial y size
      NULL,                    // parent window handle
      NULL,                    // window menu handle
      hInstance,               // program instance handle
      NULL);                   // creation parameters

   ShowWindow(window,nCmdShow);
   UpdateWindow(window);

   while (GetMessage(&msg,NULL,0,0))
   {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   return msg.wParam;
}

/****************************************************************************\
*                                                                            *
*  WindowProc                                                                *
*                                                                            *
*  Window procedure to handle messages sent to the window.                   *
*                                                                            *
\****************************************************************************/

HDC      hdc;
HMENU    hmenu;
HPALETTE hpal;
UINT     cxClient, cyClient;
int      hvb;
int      x, y;
int      xlimit, ylimit;

long WINAPI _export WindowProc(HWND window, UINT message,
                               UINT wParam, LONG lParam)
{
   PAINTSTRUCT ps;

   switch (message)
   {
      case WM_CREATE:
         hdc = GetDC(window);
         fg_setdc(hdc);
         hpal = fg_defpal();
         fg_realize(hpal);

         fg_vbinit();
         hvb = fg_vballoc(WIDTH,HEIGHT);
         fg_vbopen(hvb);
         fg_vbcolors();

         fg_showbmp("PORCH.BMP",0);
         x = y = 0;

         hmenu = GetMenu(window);
         return 0;

      case WM_COMMAND:
         switch (wParam)
         {
            case IDM_LEFT:
               if (x == 0)
               {
                  EnableMenuItem(hmenu,IDM_RIGHT,MF_ENABLED);
                  DrawMenuBar(window);
               }
               x++;
               fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
               if (x == xlimit)
               {
                  EnableMenuItem(hmenu,IDM_LEFT,MF_GRAYED);
                  DrawMenuBar(window);
               }
               return 0;

            case IDM_RIGHT:
               if (x == xlimit)
               {
                  EnableMenuItem(hmenu,IDM_LEFT,MF_ENABLED);
                  DrawMenuBar(window);
               }
               x--;
               fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
               if (x == 0)
               {
                  EnableMenuItem(hmenu,IDM_RIGHT,MF_GRAYED);
                  DrawMenuBar(window);
               }
               return 0;

            case IDM_UP:
               if (y == 0)
               {
                  EnableMenuItem(hmenu,IDM_DOWN,MF_ENABLED);
                  DrawMenuBar(window);
               }
               y++;
               fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
               if (y == ylimit)
               {
                  EnableMenuItem(hmenu,IDM_UP,MF_GRAYED);
                  DrawMenuBar(window);
               }
               return 0;

            case IDM_DOWN:
               if (y == ylimit)
               {
                  EnableMenuItem(hmenu,IDM_UP,MF_ENABLED);
                  DrawMenuBar(window);
               }
               y--;
               fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
               if (y == 0)
               {
                  EnableMenuItem(hmenu,IDM_DOWN,MF_GRAYED);
                  DrawMenuBar(window);
               }
               return 0;

            case IDM_RESET:
               x = y = 0;
               fg_vbpaste(0,WIDTH-1,0,HEIGHT-1,0,HEIGHT-1);
               if (xlimit > 0) EnableMenuItem(hmenu,IDM_LEFT,MF_ENABLED);
               if (ylimit > 0) EnableMenuItem(hmenu,IDM_UP,MF_ENABLED);
               EnableMenuItem(hmenu,IDM_RIGHT,MF_GRAYED);
               EnableMenuItem(hmenu,IDM_DOWN,MF_GRAYED);
               DrawMenuBar(window);
               return 0;

            case IDM_QUIT:
               SendMessage(window,WM_CLOSE,0,0L);
               return 0;
         }
         break;

      case WM_PAINT:
         BeginPaint(window,&ps);
         fg_vbpaste(x,x+(WIDTH-1),y,y+(HEIGHT-1),0,HEIGHT-1);
         EndPaint(window,&ps);
         return 0;

      case WM_SETFOCUS:
         fg_realize(hpal);
         InvalidateRect(window,NULL,TRUE);
         return 0;

      case WM_SIZE:
         cxClient = LOWORD(lParam);
         cyClient = HIWORD(lParam);
         if (cxClient < WIDTH)
         {
            xlimit = WIDTH - cxClient;
            if (x < xlimit) EnableMenuItem(hmenu,IDM_LEFT,MF_ENABLED);
            if (x > 0)      EnableMenuItem(hmenu,IDM_RIGHT,MF_ENABLED);
         }
         else
         {
            xlimit = 0;
            EnableMenuItem(hmenu,IDM_LEFT,MF_GRAYED);
            EnableMenuItem(hmenu,IDM_RIGHT,MF_GRAYED);
         }
         if (cyClient < HEIGHT)
         {
            ylimit = HEIGHT - cyClient;
            if (y < ylimit) EnableMenuItem(hmenu,IDM_UP,MF_ENABLED);
            if (y > 0)      EnableMenuItem(hmenu,IDM_DOWN,MF_ENABLED);
         }
         else
         {
            ylimit = 0;
            EnableMenuItem(hmenu,IDM_UP,MF_GRAYED);
            EnableMenuItem(hmenu,IDM_DOWN,MF_GRAYED);
         }
         DrawMenuBar(window);
         return 0;

      case WM_DESTROY:
         fg_vbclose();
         fg_vbfree(hvb);
         fg_vbfin();
         DeleteObject(hpal);
         ReleaseDC(window,hdc);
         PostQuitMessage(0);
         return 0;
   }
   return DefWindowProc(window,message,wParam,lParam);
}
